/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.navigation;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.upgrade.UpgradeVersionService;
import com.atlassian.jira.plugin.navigation.DefaultPluggableTopNavigation;
import com.atlassian.jira.plugin.navigation.TopNavigationModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class GreenHopperHeadsUpDisplay
extends DefaultPluggableTopNavigation {
    protected final LoggerWrapper log = LoggerWrapper.with(((Object)((Object)this)).getClass());
    @Autowired
    private UpgradeVersionService upgradeVersionService;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    private TopNavigationModuleDescriptor descriptor;

    public void init(TopNavigationModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getHtml(HttpServletRequest request) {
        try {
            return this.implementation(request);
        }
        catch (Exception unexpected) {
            this.log.error("GreenHopper top navigation threw an unexpected exception", new Object[0]);
            this.log.exception(unexpected);
            return "";
        }
    }

    private String implementation(HttpServletRequest request) {
        if (this.jiraAuthenticationContext.getUser() == null) {
            return "";
        }
        UpgradeVersionService.PluginRunInfo pluginRunInfo = this.upgradeVersionService.getCurrentPluginRunInfo();
        if (this.upgradeVersionService.versionLooksKosher()) {
            return "";
        }
        I18n2 i18n = this.i18nFactoryService.getI18n(this.jiraAuthenticationContext.getUser());
        MapBuilder params = MapBuilder.newBuilder();
        params.add((Object)"i18n", (Object)i18n);
        if (pluginRunInfo.isDowngrade()) {
            params.add((Object)"mainMsg", (Object)i18n.getText("gh.error.greenhopper.unavailable.downgrade", (Object)pluginRunInfo.getCurrentVersion(), (Object)pluginRunInfo.getPreviousVersion()));
            params.add((Object)"secondaryMsg", (Object)i18n.getText("gh.error.greenhopper.unavailable.downgrade.2"));
        } else {
            params.add((Object)"mainMsg", (Object)i18n.getText("gh.error.greenhopper.unavailable.1"));
            params.add((Object)"secondaryMsg", (Object)i18n.getText("gh.error.greenhopper.unavailable.2"));
        }
        return this.descriptor.getTopNavigationHtml(request, params.toMap());
    }
}

