/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.integration;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.integration.TeamCalendarsSprintList;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Path(value="integration/teamcalendars")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class TeamCalendarsResource
extends AbstractResource {
    private SprintPermissionService sprintPermissionService;
    private SearchService searchService;
    private JiraBaseUrls jiraBaseUrls;
    private SavedFilterService savedFilterService;
    private SprintQueryService sprintQueryService;

    public TeamCalendarsResource(SprintPermissionService sprintPermissionService, SearchService searchService, JiraBaseUrls jiraBaseUrls, SavedFilterService savedFilterService, SprintQueryService sprintQueryService) {
        this.sprintPermissionService = sprintPermissionService;
        this.searchService = searchService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.savedFilterService = savedFilterService;
        this.sprintQueryService = sprintQueryService;
    }

    @Path(value="sprint/list")
    @GET
    @AnonymousAllowed
    public Response getSprints(final @QueryParam(value="jql") String jql, final @QueryParam(value="searchFilterId") long searchFilterId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                Query theQuery = null;
                ApplicationUser user = TeamCalendarsResource.this.getUser();
                if (0L < searchFilterId) {
                    ServiceOutcome<SearchRequest> searchRequest = TeamCalendarsResource.this.savedFilterService.getSavedFilter(user, searchFilterId);
                    if (!searchRequest.isValid()) {
                        return TeamCalendarsResource.this.createBadRequestResponse();
                    }
                    theQuery = searchRequest.getValue().getQuery();
                } else if (StringUtils.isNotBlank((CharSequence)jql)) {
                    SearchService.ParseResult jqlParseResult = TeamCalendarsResource.this.searchService.parseQuery(user, jql);
                    if (!jqlParseResult.isValid()) {
                        return TeamCalendarsResource.this.createBadRequestResponse();
                    }
                    theQuery = jqlParseResult.getQuery();
                }
                if (null == theQuery) {
                    return TeamCalendarsResource.this.createBadRequestResponse();
                }
                ServiceOutcome teamCalendarsSprintList = TeamCalendarsResource.this.loadSprintList(user, theQuery);
                TeamCalendarsResource.this.check(teamCalendarsSprintList);
                return Response.ok(teamCalendarsSprintList.getValue()).build();
            }
        });
    }

    private ServiceOutcome<TeamCalendarsSprintList> loadSprintList(ApplicationUser user, Query query) {
        ServiceOutcome<List<Sprint>> sprints = this.sprintQueryService.getSprints(user, query);
        if (!sprints.isValid()) {
            return ServiceOutcomeImpl.error(sprints);
        }
        if (sprints.getValue().isEmpty()) {
            return ServiceOutcomeImpl.ok(this.createEmptyTeamCalendarsSprintList());
        }
        ServiceOutcome<Map<Sprint, Set<Project>>> sprintToProjectsOutcome = this.sprintQueryService.getProjects(user, sprints.getValue());
        if (!sprintToProjectsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(sprintToProjectsOutcome);
        }
        ServiceOutcome<Map<Sprint, Boolean>> sprintUpdatePermissions = this.sprintPermissionService.canUpdateSprints(user, sprints.getValue());
        return ServiceOutcomeImpl.ok(this.toSprintList(user, sprints.getValue(), sprintToProjectsOutcome.getValue(), sprintUpdatePermissions.getValue()));
    }

    private TeamCalendarsSprintList createEmptyTeamCalendarsSprintList() {
        TeamCalendarsSprintList sprintList = new TeamCalendarsSprintList();
        sprintList.jodaTimeZoneId = DateTimeZone.getDefault().getID();
        sprintList.sprints = Collections.emptyList();
        return sprintList;
    }

    private TeamCalendarsSprintList toSprintList(ApplicationUser user, List<Sprint> sprints, Map<Sprint, Set<Project>> sprintToProjects, Map<Sprint, Boolean> sprintUpdatePermissions) {
        DateTimeZone systemTimeZone = DateTimeZone.getDefault();
        DateTimeFormatter sprintDateFormat = DateTimeFormat.forPattern((String)"ddMMyyyyHHmmSS").withZone(systemTimeZone);
        TeamCalendarsSprintList sprintList = new TeamCalendarsSprintList();
        sprintList.jodaTimeZoneId = systemTimeZone.getID();
        ArrayList<TeamCalendarsSprintList.TeamCalendarsSprint> calendarSprints = new ArrayList<TeamCalendarsSprintList.TeamCalendarsSprint>();
        for (Sprint sprint : sprints) {
            TeamCalendarsSprintList.TeamCalendarsSprint teamCalendarsSprint;
            Boolean canUpdate;
            Set<Object> projects = sprintToProjects.get(sprint);
            if (projects == null) {
                projects = Collections.emptySet();
            }
            if ((canUpdate = sprintUpdatePermissions.get(sprint)) == null) {
                canUpdate = false;
            }
            if ((teamCalendarsSprint = this.toTeamCalendarSprint(sprint, projects, canUpdate, sprintDateFormat, systemTimeZone)) == null) continue;
            calendarSprints.add(teamCalendarsSprint);
        }
        sprintList.sprints = calendarSprints;
        return sprintList;
    }

    private TeamCalendarsSprintList.TeamCalendarsSprint toTeamCalendarSprint(Sprint sprint, Set<Project> projects, boolean canUpdate, DateTimeFormatter sprintDateFormat, DateTimeZone systemTimeZone) {
        TeamCalendarsSprintList.TeamCalendarsSprint teamCalendarsSprint = new TeamCalendarsSprintList.TeamCalendarsSprint();
        teamCalendarsSprint.id = sprint.getId();
        DateTime startDate = sprint.getStartDate();
        DateTime endDate = sprint.getEndDate();
        if (startDate == null || endDate == null) {
            return null;
        }
        teamCalendarsSprint.start = sprintDateFormat.print((ReadableInstant)startDate.withZone(systemTimeZone));
        teamCalendarsSprint.end = sprintDateFormat.print((ReadableInstant)endDate.withZone(systemTimeZone));
        teamCalendarsSprint.name = sprint.getName();
        teamCalendarsSprint.closed = sprint.getState() == Sprint.State.CLOSED;
        teamCalendarsSprint.editable = canUpdate;
        teamCalendarsSprint.projects = this.toSprintProjects(projects);
        UrlBuilder urlBuilder = new UrlBuilder(this.jiraBaseUrls.baseUrl()).addPaths("/secure/GHGoToBoard.jspa").addParameter("sprintId", (Object)sprint.getId());
        teamCalendarsSprint.viewBoardsUrl = urlBuilder.asUrlString();
        return teamCalendarsSprint;
    }

    private List<TeamCalendarsSprintList.SprintProject> toSprintProjects(Set<Project> projects) {
        TreeSet<Project> sortedProjects = new TreeSet<Project>(new Comparator<Project>(){

            @Override
            public int compare(Project leftProject, Project rightProject) {
                int result = leftProject.getName().toLowerCase().compareTo(rightProject.getName().toLowerCase());
                return 0 == result ? leftProject.getKey().compareTo(rightProject.getKey()) : result;
            }
        });
        sortedProjects.addAll(projects);
        ArrayList<TeamCalendarsSprintList.SprintProject> result = new ArrayList<TeamCalendarsSprintList.SprintProject>();
        for (Project project : sortedProjects) {
            result.add(this.toSprintProject(project));
        }
        return result;
    }

    private TeamCalendarsSprintList.SprintProject toSprintProject(Project project) {
        TeamCalendarsSprintList.SprintProject sprintProject = new TeamCalendarsSprintList.SprintProject();
        sprintProject.name = project.getName();
        sprintProject.key = project.getKey();
        return sprintProject;
    }

    private Response createBadRequestResponse() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }
}

