/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.integration;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchPagesHelper {
    private static final LoggerWrapper LOG = LoggerWrapper.with(SearchPagesHelper.class);
    private static final String PARAM_QUERY = "queryString";
    private static final String PARAM_STARTINDEX = "startIndex";
    private static final String PARAM_PAGESIZE = "pageSize";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_USER = "user";
    @Autowired
    private ApplicationLinkService applicationLinkService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private JiraAuthenticationContext authCtx;
    @Autowired
    private FeatureManager featureManager;

    public ServiceOutcome<SearchResultModel> searchPages(String searchQuery) throws ResponseException {
        ApplicationLink appLink = this.applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType.class);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)"/rest/searchv3/1.0/search");
        uriBuilder.queryParam(PARAM_QUERY, new Object[]{"title:" + searchQuery + "* OR title:" + searchQuery});
        uriBuilder.queryParam(PARAM_TYPE, new Object[]{"page,blogpost"});
        uriBuilder.queryParam(PARAM_STARTINDEX, new Object[]{0});
        uriBuilder.queryParam(PARAM_PAGESIZE, new Object[]{10});
        uriBuilder.queryParam(PARAM_USER, new Object[]{""});
        String uri = uriBuilder.build(new Object[0]).toString();
        ApplicationLinkRequest request = null;
        try {
            ServiceOutcome<Boolean> userAuthenticatedOutcome;
            request = appLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, uri);
            request.setHeader("Content-Type", "application/json");
            SearchResultModel searchResultModel = (SearchResultModel)request.executeAndReturn((ReturningResponseHandler)new SearchPagesResponseHandler());
            if (searchResultModel.pages.size() == 0 && !this.featureManager.isOnDemand() && (userAuthenticatedOutcome = this.verifyUserAuthenticated(appLink)).isValid() && !userAuthenticatedOutcome.getValue().booleanValue()) {
                LOG.warn("Search for Confluence pages didn't return any results. This might be caused by a wrongly configured app link or the user not being authenticated in an 2-legged OAuth configuration.", new Object[0]);
            }
            return ServiceOutcomeImpl.ok(searchResultModel);
        }
        catch (CredentialsRequiredException e) {
            SearchResultModel searchResultModel = new SearchResultModel();
            searchResultModel.isComplete = true;
            searchResultModel.authenticationRequired = true;
            searchResultModel.applicationLinkId = appLink.getId().get();
            searchResultModel.authenticationUrl = e.getAuthorisationURI().toString();
            return ServiceOutcomeImpl.ok(searchResultModel);
        }
        catch (ResponseException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.pages.server.error", new Object[0]);
        }
    }

    private ServiceOutcome<Boolean> verifyUserAuthenticated(ApplicationLink appLink) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)"/rest/prototype/1/user/current");
        String uri = uriBuilder.build(new Object[0]).toString();
        try {
            ApplicationLinkRequest request = appLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, uri);
            Boolean userAuthenticated = (Boolean)request.executeAndReturn((ReturningResponseHandler)new VerifyUserAuthenticatedResponseHandler());
            return ServiceOutcomeImpl.ok(userAuthenticated);
        }
        catch (CredentialsRequiredException e) {
            return ServiceOutcomeImpl.ok(false);
        }
        catch (ResponseException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.pages.server.error", new Object[0]);
        }
    }

    @XmlRootElement
    public static class PageModel
    extends RestTemplate {
        @XmlElement
        public Long id;
        @XmlElement
        public String title;
        @XmlElement
        public String space;
    }

    @XmlRootElement
    public static class SearchResultModel
    extends RestTemplate {
        @XmlElement
        public List<PageModel> pages = Lists.newArrayList();
        @XmlElement
        public boolean isComplete;
        @XmlElement
        public boolean authenticationRequired;
        @XmlElement
        public String applicationLinkId;
        @XmlElement
        public String authenticationUrl;
    }

    private class VerifyUserAuthenticatedResponseHandler
    implements ReturningResponseHandler<com.atlassian.sal.api.net.Response, Boolean> {
        private VerifyUserAuthenticatedResponseHandler() {
        }

        public Boolean handle(com.atlassian.sal.api.net.Response response) throws ResponseException {
            I18n2 i18n = SearchPagesHelper.this.i18nFactoryService.getI18n(SearchPagesHelper.this.authCtx.getUser());
            Response.Status status = Response.Status.fromStatusCode((int)response.getStatusCode());
            switch (status) {
                case OK: {
                    return true;
                }
                case UNAUTHORIZED: {
                    return false;
                }
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)i18n.getText("gh.rapid.pages.server.error")).build());
        }
    }

    private class SearchPagesResponseHandler
    implements ReturningResponseHandler<com.atlassian.sal.api.net.Response, SearchResultModel> {
        private SearchPagesResponseHandler() {
        }

        public SearchResultModel handle(com.atlassian.sal.api.net.Response response) throws ResponseException {
            this.check(response);
            try {
                JSONObject json = new JSONObject(IOUtils.toString((InputStream)response.getResponseBodyAsStream()));
                SearchResultModel searchResultModel = new SearchResultModel();
                JSONArray resultArray = json.getJSONArray("results");
                for (int i = 0; i < resultArray.length(); ++i) {
                    PageModel pageModel = this.toPageModel(resultArray.getJSONObject(i));
                    if (pageModel == null) continue;
                    searchResultModel.pages.add(pageModel);
                }
                searchResultModel.isComplete = resultArray.length() == json.getInt("total");
                return searchResultModel;
            }
            catch (Exception e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            }
        }

        private PageModel toPageModel(JSONObject jsonObject) {
            try {
                PageModel pageModel = new PageModel();
                pageModel.id = jsonObject.getLong("id");
                pageModel.title = jsonObject.getString("title");
                pageModel.space = this.getSpaceName(jsonObject);
                return pageModel;
            }
            catch (JSONException e) {
                return null;
            }
        }

        private String getSpaceName(JSONObject jsonObject) {
            try {
                JSONObject searchResultContainer = jsonObject.getJSONObject("searchResultContainer");
                return searchResultContainer.getString("name");
            }
            catch (JSONException e) {
                return "";
            }
        }

        private void check(com.atlassian.sal.api.net.Response response) {
            I18n2 i18n = SearchPagesHelper.this.i18nFactoryService.getI18n(SearchPagesHelper.this.authCtx.getUser());
            Response.Status status = Response.Status.fromStatusCode((int)response.getStatusCode());
            switch (status) {
                case OK: {
                    return;
                }
                case UNAUTHORIZED: {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)i18n.getText("gh.rapid.pages.server.authentication")).build());
                }
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)i18n.getText("gh.rapid.pages.server.error")).build());
        }
    }
}

