/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.input;

import com.atlassian.greenhopper.web.input.InputParameterService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import webwork.action.ServletActionContext;

@Service(value="gh-inputParameterService")
public class InputParameterServiceImpl
implements InputParameterService {
    private static Logger log = Logger.getLogger(InputParameterServiceImpl.class);

    @Override
    public String getParameter(String name) {
        HttpServletRequest request = ServletActionContext.getRequest();
        return request.getParameter(name);
    }

    @Override
    public Long getLongParameter(String name) {
        String value = this.getParameter(name);
        if (value != null && !value.isEmpty()) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Unable to transform request parameter into long: " + name + ", " + value), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Integer getIntegerParameter(String name) {
        String value = this.getParameter(name);
        if (value != null && !value.isEmpty()) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Unable to transform request parameter into integer: " + name + ", " + value), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Boolean getBooleanParameter(String name) {
        String value = this.getParameter(name);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            if (value.equals("true")) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Unable to transform request parameter into Boolean: " + name + ", " + value));
        }
        return null;
    }
}

