/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.footer;

import com.atlassian.greenhopper.web.util.GreenHopperHelpPathResolver;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class GreenHopperFooter
implements PluggableFooter {
    @Autowired
    private WebUtilities webUtilities;
    @Autowired
    protected GreenHopperHelpPathResolver greenHopperHelpPathResolver;
    @Autowired
    private FeatureManager featureManager;
    private FooterModuleDescriptor descriptor;
    Pattern URLS = Pattern.compile("secure/(VersionBoard.jspa|TaskBoard.jspa|ChartBoard.jspa|VersionBoard.jspa|ArchiveChartBoard.jspa|Configuration.jspa.jspa|RapidBoard.jspa|RapidView.jspa|ManageRapidViews.jspa)");

    public void init(FooterModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getFullFooterHtml(HttpServletRequest request) {
        return this.descriptor.getFooterHtml(request, this.buildParameters());
    }

    public String getSmallFooterHtml(HttpServletRequest request) {
        return this.descriptor.getFooterHtml(request, this.buildParameters(true));
    }

    private Map<String, Object> buildParameters() {
        return this.buildParameters(false);
    }

    private Map<String, Object> buildParameters(boolean smallFooter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        boolean showFooter = this.showFooter();
        parameters.put("showFooter", showFooter);
        parameters.put("onDemand", this.featureManager.isOnDemand());
        if (showFooter) {
            parameters.put("buildProperties", this.webUtilities.getBuildProperties());
            parameters.put("helpPaths", new HelpPaths());
        }
        if (smallFooter) {
            parameters.put("smallFooter", Boolean.TRUE);
        }
        return parameters;
    }

    private boolean showFooter() {
        HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
        return this.URLS.matcher(httpServletRequest.getRequestURL().toString()).find();
    }

    public class HelpPaths {
        public GreenHopperHelpPathResolver.HelpPath getHelpPath(String helpPathKey) {
            return GreenHopperFooter.this.greenHopperHelpPathResolver.getHelpPath(helpPathKey);
        }
    }
}

