/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.contextprovider.issuedetailsview;

import com.atlassian.greenhopper.web.contextprovider.ContextProviderFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailsCategory;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewFieldHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FieldBlockContextProviderWrapper
implements ContextProvider {
    private static final String COMPOSED_BY_FIELDS = "composedByFields";
    public static final String FIELD_DETAILS_CATEGORY = "category";
    private final ContextProviderFactory contextProviderFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private ContextProvider fieldBlockContextProvider;
    private FieldDetailsCategory category;
    private DetailViewFieldHelper detailViewFieldHelper;
    private FieldVisibilityManager fieldVisibilityManager;

    public FieldBlockContextProviderWrapper(ContextProviderFactory contextProviderFactory, JiraAuthenticationContext jiraAuthenticationContext, DetailViewFieldHelper detailViewFieldHelper, FieldVisibilityManager fieldVisibilityManager) {
        this.contextProviderFactory = contextProviderFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.detailViewFieldHelper = detailViewFieldHelper;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public void init(Map<String, String> params) {
        String categoryStr = params.get(FIELD_DETAILS_CATEGORY);
        Preconditions.checkArgument((categoryStr != null ? 1 : 0) != 0, (Object)"Must supply parameter 'category'");
        this.category = FieldDetailsCategory.valueOf(categoryStr);
        Preconditions.checkArgument((!this.category.equals((Object)FieldDetailsCategory.LINKS) ? 1 : 0) != 0, (Object)"LINKS category is not supported as a field block.");
        this.fieldBlockContextProvider = this.contextProviderFactory.loadContextProviderOfViewIssuePlugin(this.category);
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Map<String, Object> defaultContext = this.getDefaultVelocityParams(context, this.jiraAuthenticationContext);
        Issue issue = (Issue)context.get("issue");
        List<Field> visibleFields = this.getVisibleFields(defaultContext);
        List filteredFields = visibleFields.stream().filter(field -> this.detailViewFieldHelper.isInCategory((Field)field, this.category)).filter(field -> this.isVisible((Field)field, issue)).filter(field -> this.isInAvailableContext((Field)field, issue)).collect(Collectors.toList());
        defaultContext.put(COMPOSED_BY_FIELDS, filteredFields);
        return this.fieldBlockContextProvider.getContextMap(defaultContext);
    }

    private List<Field> getVisibleFields(Map<String, Object> map) {
        return (List)map.getOrDefault("visibleFields", Lists.newArrayList());
    }

    @VisibleForTesting
    Map<String, Object> getDefaultVelocityParams(Map<String, Object> context, JiraAuthenticationContext jiraAuthenticationContext) {
        return JiraVelocityUtils.getDefaultVelocityParams(context, (JiraAuthenticationContext)jiraAuthenticationContext);
    }

    private boolean isVisible(Field field, Issue issue) {
        return this.fieldVisibilityManager.isFieldVisible(field.getId(), issue);
    }

    private boolean isInAvailableContext(Field customField, Issue issue) {
        if (customField instanceof CustomField) {
            return ((CustomField)customField).isRelevantForIssueContext((IssueContext)issue);
        }
        return true;
    }
}

