/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.contextprovider.issuedetailsview;

import com.atlassian.greenhopper.web.contextprovider.ContextProviderFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.viewissue.ActivityBlockViewIssueContextProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class CommentBlockContextProviderWrapper
implements ContextProvider {
    private static final String ORDER_DESC = "desc";
    private static final String COMMENT_TAB_PANEL_COMPLETE_KEY = "com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel";
    private final VelocityRequestContextFactory requestContextFactory;
    private final IssueTabPanelInvoker issueTabPanelInvoker;
    private final ContextProvider activityBlockViewIssueContextProvider;

    public CommentBlockContextProviderWrapper(ContextProviderFactory contextProviderFactory, VelocityRequestContextFactory requestContextFactory, IssueTabPanelInvoker issueTabPanelInvoker) {
        this.activityBlockViewIssueContextProvider = contextProviderFactory.loadContextProviderOfViewIssuePlugin(ActivityBlockViewIssueContextProvider.class);
        this.requestContextFactory = requestContextFactory;
        this.issueTabPanelInvoker = issueTabPanelInvoker;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        boolean isAsync = true;
        context.put("isAsynchronousRequest", isAsync);
        HashMap contextMap = MapBuilder.newBuilder((Map)this.activityBlockViewIssueContextProvider.getContextMap(context)).toHashMap();
        List allTabPanels = contextMap.getOrDefault("tabPanels", Lists.newArrayListWithExpectedSize((int)0));
        String sortOrder = (String)contextMap.get("actionsSortOrder");
        List<IssueAction> commentActions = this.extractCommentTabPanel(contextMap, this.requestContextFactory.getJiraVelocityRequestContext(), isAsync, allTabPanels, sortOrder);
        contextMap.put("tabPanels", Collections.emptyList());
        contextMap.put("hasPanels", true);
        contextMap.put("actions", commentActions);
        contextMap.put("isSortable", CollectionUtils.isNotEmpty(commentActions));
        return contextMap;
    }

    private List<IssueAction> extractCommentTabPanel(Map<String, Object> context, VelocityRequestContext requestContext, boolean isAsync, List<IssueTabPanelModuleDescriptor> allTabPanels, String sortOrder) {
        Issue issue = (Issue)context.get("issue");
        boolean showAllFlag = requestContext.getRequestParameter("showAll") != null;
        String focusId = requestContext.getRequestParameter("focusedCommentId");
        ApplicationUser user = (ApplicationUser)context.get("user");
        GetActionsRequest getActionsRequest = new GetActionsRequest(issue, user, isAsync, showAllFlag, focusId);
        Optional<IssueTabPanelModuleDescriptor> commentTabPanel = allTabPanels.stream().filter(issueTabPanelModuleDescriptor -> COMMENT_TAB_PANEL_COMPLETE_KEY.equals(issueTabPanelModuleDescriptor.getCompleteKey())).findFirst();
        List commentActions = this.issueTabPanelInvoker.invokeGetActions(getActionsRequest, commentTabPanel.get());
        return this.sort(commentActions, sortOrder);
    }

    private List<IssueAction> sort(List<IssueAction> actions, String actionSortOrder) {
        ArrayList clonedActions = Lists.newArrayList(actions);
        if (ORDER_DESC.equals(actionSortOrder)) {
            Collections.reverse(clonedActions);
        }
        return clonedActions;
    }
}

