/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.contextprovider;

import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelProviderImpl;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.manager.issuelink.EpicLinkManager;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.web.contextprovider.IssuesInEpicContext;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssuesInEpicContextProvider
implements ContextProvider {
    @Autowired
    private VelocityRequestContextFactory requestContextFactory;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private EpicLinkManager epicLinkManager;
    @Autowired
    private WebUtilities webUtilities;
    @Autowired
    private EpicLabelProviderImpl epicLabelProvider;
    @Autowired
    private SoyTemplateRendererProvider soyTemplateRendererProvider;

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Issue epic = (Issue)context.get("issue");
        ApplicationUser user = (ApplicationUser)context.get("user");
        CustomField defaultRankField = this.rankCustomFieldService.getDefaultRankField();
        ArrayList<IssuesInEpicContext.IssueInfo> issues = new ArrayList<IssuesInEpicContext.IssueInfo>();
        List<Issue> issuesInEpic = this.epicLinkManager.getIssuesInEpic(epic);
        for (Issue issue : issuesInEpic) {
            if (!this.permissionService.hasPermission(user, issue, 10)) continue;
            IssuesInEpicContext.IssueInfo issueInfo = new IssuesInEpicContext.IssueInfo(issue);
            LexoRank rank = (LexoRank)issue.getCustomFieldValue(defaultRankField);
            if (rank == null) {
                rank = LexoRank.max();
            }
            issueInfo.setRank(rank.format());
            issues.add(issueInfo);
        }
        this.sortIssuesByRank(issues);
        String epicName = this.epicLabelProvider.getEpicLabel(epic);
        return MapBuilder.newBuilder().add((Object)"issuesInEpicContext", (Object)new IssuesInEpicContext(this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl(), epic.getKey(), epicName, issues, this.webUtilities)).add((Object)"soyRenderer", (Object)this.soyTemplateRendererProvider.getRenderer()).toMap();
    }

    private void sortIssuesByRank(List<IssuesInEpicContext.IssueInfo> issues) {
        Collections.sort(issues, new Comparator<IssuesInEpicContext.IssueInfo>(){

            @Override
            public int compare(IssuesInEpicContext.IssueInfo firstIssue, IssuesInEpicContext.IssueInfo secondIssue) {
                return firstIssue.getRank().compareTo(secondIssue.getRank());
            }
        });
    }
}

