/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.contextprovider;

import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import java.util.List;

public class IssuesInEpicContext {
    private final String epicKey;
    private final String epicName;
    private final List<IssueInfo> issues;
    private WebUtilities util;
    private final String baseUrl;
    private Boolean hideTable;

    public IssuesInEpicContext(String baseUrl, String epicKey, String epicName, List<IssueInfo> issues, WebUtilities util) {
        this.baseUrl = baseUrl;
        this.issues = issues;
        this.util = util;
        this.epicKey = epicKey;
        this.epicName = epicName;
        this.hideTable = issues.size() == 0;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<IssueInfo> getIssues() {
        return this.issues;
    }

    public WebUtilities getUtil() {
        return this.util;
    }

    public String getEpicKey() {
        return this.epicKey;
    }

    public String getEpicName() {
        return this.epicName;
    }

    public String getTime() {
        return String.valueOf(System.currentTimeMillis());
    }

    public String getHideTable() {
        return this.hideTable.toString();
    }

    public static class IssueInfo {
        private final Issue issue;
        private String rank;

        public IssueInfo(Issue issue) {
            this.issue = issue;
        }

        public Long getId() {
            return this.issue.getId();
        }

        public String getKey() {
            return this.issue.getKey();
        }

        public String getSummary() {
            return this.issue.getSummary();
        }

        public Status getStatus() {
            return this.issue.getStatusObject();
        }

        public String getStatusUrl() {
            return this.issue.getStatusObject().getIconUrl();
        }

        public String getStatusName() {
            return this.issue.getStatusObject().getName();
        }

        public String getTypeUrl() {
            return this.issue.getIssueTypeObject().getIconUrl();
        }

        public String getTypeName() {
            return this.issue.getIssueTypeObject().getName();
        }

        public String getAssigneeDisplayName() {
            if (this.issue.getAssignee() != null) {
                return this.issue.getAssignee().getDisplayName();
            }
            return null;
        }

        public String getAssignee() {
            if (this.issue.getAssignee() != null) {
                return this.issue.getAssignee().getName();
            }
            return null;
        }

        public boolean isResolved() {
            return this.issue.getResolutionObject() != null;
        }

        public Issue getIssue() {
            return this.issue;
        }

        public void setRank(String rank) {
            this.rank = rank;
        }

        public String getRank() {
            return this.rank;
        }
    }
}

