/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.contextprovider;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilterWithBoardsWarningContextProvider
implements ContextProvider {
    @VisibleForTesting
    static final String CONTEXT_KEY_SEARCH_REQUEST = "searchRequest";
    @VisibleForTesting
    static final String CONTEXT_KEY_BOARD_COUNT = "boardCount";
    @VisibleForTesting
    static final String CONTEXT_KEY_BOARD_NAMES_TO_LINKS = "boardNamesToLinks";
    private final RapidViewManager rapidViewManager;

    @Autowired
    public FilterWithBoardsWarningContextProvider(RapidViewManager rapidViewManager) {
        this.rapidViewManager = rapidViewManager;
    }

    public void init(Map<String, String> params) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        SearchRequest searchRequest = (SearchRequest)context.get(CONTEXT_KEY_SEARCH_REQUEST);
        List<RapidView> dependentBoards = this.rapidViewManager.findByFilterId(searchRequest.getId());
        return this.getContextMap(dependentBoards);
    }

    private Map<String, Object> getContextMap(List<RapidView> dependentBoards) {
        HashMap context = Maps.newHashMap();
        context.put(CONTEXT_KEY_BOARD_COUNT, dependentBoards.size());
        LinkedHashMap boardNamesToLinks = Maps.newLinkedHashMap();
        for (RapidView rapidView : dependentBoards) {
            boardNamesToLinks.put(rapidView.getName(), this.boardConfigurationUrl(rapidView));
        }
        context.put(CONTEXT_KEY_BOARD_NAMES_TO_LINKS, boardNamesToLinks);
        return context;
    }

    private String boardConfigurationUrl(RapidView rapidView) {
        return ExecutingHttpRequest.get().getContextPath() + "/secure/RapidView.jspa?rapidView=" + rapidView.getId();
    }
}

