/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.contextprovider;

import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailsCategory;
import com.atlassian.jira.plugin.viewissue.DateBlockContextProvider;
import com.atlassian.jira.plugin.viewissue.DetailsBlockContextProvider;
import com.atlassian.jira.plugin.viewissue.PeopleBlockContextProvider;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextProviderFactory {
    @Autowired
    private WebFragmentHelper webFragmentHelper;
    @Autowired
    private PluginAccessor pluginAccessor;
    private static final Map<FieldDetailsCategory, Class<? extends ContextProvider>> CATEGORY_TO_CLASS = ImmutableMap.of((Object)((Object)FieldDetailsCategory.DETAILS), DetailsBlockContextProvider.class, (Object)((Object)FieldDetailsCategory.PEOPLE), PeopleBlockContextProvider.class, (Object)((Object)FieldDetailsCategory.DATES), DateBlockContextProvider.class);

    public ContextProvider loadContextProviderOfViewIssuePlugin(FieldDetailsCategory fieldDetailsCategory) {
        Class<? extends ContextProvider> contextProviderClass = CATEGORY_TO_CLASS.get((Object)fieldDetailsCategory);
        return this.loadContextProviderOfViewIssuePlugin(contextProviderClass);
    }

    public ContextProvider loadContextProviderOfViewIssuePlugin(Class<? extends ContextProvider> contextProviderClass) {
        return this.loadContextProvider(contextProviderClass, "com.atlassian.jira.jira-view-issue-plugin");
    }

    public ContextProvider loadContextProvider(Class<? extends ContextProvider> contextProviderClass, String pluginKey) {
        try {
            return this.webFragmentHelper.loadContextProvider(contextProviderClass.getName(), this.pluginAccessor.getPlugin(pluginKey));
        }
        catch (ConditionLoadingException exception) {
            throw new PluginParseException(String.format("Could not locate ContextProvider implementation named %s.", contextProviderClass.getName()), (Throwable)exception);
        }
    }
}

