/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.contextprovider;

import com.atlassian.greenhopper.manager.issuelink.EpicLinkManager;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.RecentSprintHistoryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.web.contextprovider.AgileIssueWebPanelContext;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.base.Strings;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AgileIssueWebPanelContextProvider
implements ContextProvider {
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private VelocityRequestContextFactory requestContextFactory;
    @Autowired
    private DateTimeFormatterFactory dateTimeFormatterFactory;
    @Autowired
    private WebUtilities webUtilities;
    @Autowired
    private EpicLinkManager epicLinkManager;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private RecentSprintHistoryService recentSprintHistoryService;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = (ApplicationUser)context.get("user");
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        Collection sprintsForIssue = (Collection)issue.getCustomFieldValue(defaultSprintField);
        ArrayList<Sprint> activeSprints = new ArrayList<Sprint>();
        ArrayList<Sprint> futureSprints = new ArrayList<Sprint>();
        ArrayList<Sprint> closedSprints = new ArrayList<Sprint>();
        if (sprintsForIssue != null) {
            for (Sprint sprint : sprintsForIssue) {
                switch (sprint.getState()) {
                    case ACTIVE: {
                        activeSprints.add(sprint);
                        break;
                    }
                    case FUTURE: {
                        futureSprints.add(sprint);
                        break;
                    }
                    case CLOSED: {
                        closedSprints.add(sprint);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown sprint state: " + (Object)((Object)sprint.getState()));
                    }
                }
                this.recentSprintHistoryService.storeSprint(user, sprint);
            }
        }
        boolean linkedToEpic = false;
        Issue epic = null;
        String epicName = null;
        String epicColor = null;
        Option<Issue> epicOption = this.epicLinkManager.getEpic(issue);
        if (!epicOption.isEmpty()) {
            linkedToEpic = true;
            epic = (Issue)epicOption.get();
            epicName = StringUtils.trimToNull((String)((String)epic.getCustomFieldValue(this.epicCustomFieldService.getDefaultEpicLabelField())));
            String defaultEpicColor = (String)epic.getCustomFieldValue(this.epicCustomFieldService.getDefaultEpicColorField());
            epicColor = Strings.isNullOrEmpty((String)defaultEpicColor) ? "#ffffff" : defaultEpicColor;
        }
        return MapBuilder.newBuilder().add((Object)"agilePanelContext", (Object)new AgileIssueWebPanelContext(issue, activeSprints, futureSprints, closedSprints, linkedToEpic, epic, epicName, epicColor, this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl(), this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE), this.webUtilities)).toMap();
    }
}

