/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.contextprovider;

import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.Issue;
import java.util.List;

public class AgileIssueWebPanelContext {
    private final Issue issue;
    private final List<Sprint> activeSprints;
    private final List<Sprint> futureSprints;
    private final List<Sprint> completedSprints;
    private final boolean hasSprints;
    private final String baseUrl;
    private final DateTimeFormatter dtf;
    private final WebUtilities util;
    private boolean linkedToEpic;
    private final String epicName;
    private final String epicColor;
    private final Issue epic;

    public AgileIssueWebPanelContext(Issue issue, List<Sprint> activeSprints, List<Sprint> futureSprints, List<Sprint> completedSprints, boolean linkedToEpic, Issue epic, String epicName, String epicColor, String baseUrl, DateTimeFormatter dtf, WebUtilities util) {
        this.issue = issue;
        this.activeSprints = activeSprints;
        this.futureSprints = futureSprints;
        this.completedSprints = completedSprints;
        this.hasSprints = !activeSprints.isEmpty() || !futureSprints.isEmpty() || !completedSprints.isEmpty();
        this.linkedToEpic = linkedToEpic;
        this.epic = epic;
        this.epicName = epicName;
        this.epicColor = epicColor;
        this.baseUrl = baseUrl;
        this.dtf = dtf;
        this.util = util;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public List<Sprint> getActiveSprints() {
        return this.activeSprints;
    }

    public List<Sprint> getFutureSprints() {
        return this.futureSprints;
    }

    public List<Sprint> getCompletedSprints() {
        return this.completedSprints;
    }

    public boolean isHasSprints() {
        return this.hasSprints;
    }

    public String getEpicName() {
        return this.epicName;
    }

    public String getEpicColor() {
        return this.epicColor;
    }

    public boolean isLinkedToEpic() {
        return this.linkedToEpic;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public DateTimeFormatter getDtf() {
        return this.dtf;
    }

    public WebUtilities getUtil() {
        return this.util;
    }

    public Issue getEpic() {
        return this.epic;
    }
}

