/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.configuration;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.manager.lexorank.LexoRankDao;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.manager.lexorank.suspend.LexoRankSuspendManager;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.lexorank.LexoRankStatisticsAgent;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancer;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancingService;
import com.atlassian.greenhopper.service.lexorank.integrity.LexoRankIntegrityCheckReport;
import com.atlassian.greenhopper.service.lexorank.integrity.LexoRankIntegrityCheckerImpl;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.configuration.LexoRankHelper;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="lexorank")
@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LexoRankResource
extends AbstractResource {
    private PermissionService permissionService;
    private LexoRankStatisticsAgent lexoRankStatisticsAgent;
    private LexoRankDao lexoRankDao;
    private LexoRankCustomFieldService lexoRankCustomFieldService;
    private LexoRankManager lexoRankManager;
    private LexoRankIntegrityCheckerImpl lexoRankIntegrityChecker;
    private final LexoRankHelper lexoRankHelper;
    private LexoRankSuspendManager lexoRankSuspendManager;

    public LexoRankResource(PermissionService permissionService, LexoRankStatisticsAgent lexoRankStatisticsAgent, LexoRankDao lexoRankDao, LexoRankCustomFieldService lexoRankCustomFieldService, LexoRankManager lexoRankManager, LexoRankIntegrityCheckerImpl lexoRankIntegrityChecker, LexoRankHelper lexoRankHelper, LexoRankSuspendManager lexoRankSuspendManager) {
        this.permissionService = permissionService;
        this.lexoRankStatisticsAgent = lexoRankStatisticsAgent;
        this.lexoRankDao = lexoRankDao;
        this.lexoRankCustomFieldService = lexoRankCustomFieldService;
        this.lexoRankManager = lexoRankManager;
        this.lexoRankIntegrityChecker = lexoRankIntegrityChecker;
        this.lexoRankHelper = lexoRankHelper;
        this.lexoRankSuspendManager = lexoRankSuspendManager;
    }

    @GET
    @Path(value="/balance")
    public Response balanceStatus() {
        if (!this.permissionService.isJiraAdministrator(this.getUser()) && !this.permissionService.isJiraSystemAdministrator(this.getUser())) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.lexorank.balancer.error.not.permitted", new Object[0]));
        }
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                return Response.ok((Object)LexoRankResource.this.lexoRankHelper.getBalanceStatus()).build();
            }
        });
    }

    @POST
    @Path(value="/balance")
    public Response balance(final @DefaultValue(value="0") @QueryParam(value="fieldId") long fieldId) {
        if (!this.permissionService.isJiraAdministrator(this.getUser()) && !this.permissionService.isJiraSystemAdministrator(this.getUser())) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.lexorank.balancer.error.not.permitted", new Object[0]));
        }
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                if (fieldId == 0L) {
                    return Response.ok((Object)LexoRankResource.this.check(LexoRankResource.this.lexoRankHelper.requestFullBalance())).build();
                }
                return Response.ok((Object)LexoRankResource.this.check(LexoRankResource.this.lexoRankHelper.requestBalance(fieldId))).build();
            }
        });
    }

    @PUT
    @Path(value="/balance")
    public Response suspendBalancing(LexoRankSuspendRequest lexoRankSuspendRequest) {
        if (!this.permissionService.isJiraAdministrator(this.getUser()) && !this.permissionService.isJiraSystemAdministrator(this.getUser())) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.lexorank.service.error.balancing.suspended.not.permitted", new Object[0]));
        }
        return this.responseWithoutAccessCheck(() -> {
            ServiceOutcome<Boolean> suspendResult = lexoRankSuspendRequest.suspendBalancing != false ? this.lexoRankSuspendManager.suspendLexoRankBalancing() : this.lexoRankSuspendManager.resumeLexoRankBalancing();
            this.check(suspendResult);
            return Response.ok((Object)this.lexoRankHelper.getBalanceStatus()).build();
        });
    }

    @GET
    @Path(value="/report")
    public Response report() {
        if (!this.permissionService.isJiraAdministrator(this.getUser()) && !this.permissionService.isJiraSystemAdministrator(this.getUser())) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.lexorank.report.error.not.permitted", new Object[0]));
        }
        return Response.ok((Object)this.lexoRankStatisticsAgent.generateReport()).build();
    }

    @GET
    @Path(value="/duplicates")
    public Response getDuplicates() {
        if (!this.permissionService.isJiraAdministrator(this.getUser()) && !this.permissionService.isJiraSystemAdministrator(this.getUser())) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.lexorank.duplicates.error.not.permitted", new Object[0]));
        }
        List<CustomField> rankFields = this.lexoRankCustomFieldService.getRankFields();
        ArrayList rankFieldDuplicateRanksList = Lists.newArrayList();
        for (CustomField rankField : rankFields) {
            Map<String, Long> duplicateRowsForFieldId = this.lexoRankDao.countDuplicateRowsForFieldId(rankField.getIdAsLong());
            RankFieldDuplicateRanks rankFieldDuplicateRanks = new RankFieldDuplicateRanks();
            rankFieldDuplicateRanks.fieldId = rankField.getIdAsLong();
            rankFieldDuplicateRanks.fieldName = rankField.getFieldName();
            rankFieldDuplicateRanks.duplicateRanks = duplicateRowsForFieldId;
            rankFieldDuplicateRanksList.add(rankFieldDuplicateRanks);
        }
        return Response.ok((Object)rankFieldDuplicateRanksList).build();
    }

    @PUT
    @Path(value="/duplicates")
    public Response healDuplicates() {
        if (!this.permissionService.isJiraAdministrator(this.getUser()) && !this.permissionService.isJiraSystemAdministrator(this.getUser())) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.lexorank.duplicates.error.not.permitted", new Object[0]));
        }
        List<CustomField> rankFields = this.lexoRankCustomFieldService.getRankFields();
        for (CustomField rankField : rankFields) {
            ServiceOutcome<Void> healDuplicatesOutcome = this.lexoRankManager.healDuplicates(rankField.getIdAsLong());
            this.check(healDuplicatesOutcome);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/integrity")
    public Response integrityReport() {
        if (!this.permissionService.isJiraAdministrator(this.getUser()) && !this.permissionService.isJiraSystemAdministrator(this.getUser())) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.lexorank.integrity.error.not.permitted", new Object[0]));
        }
        List<CustomField> rankFields = this.lexoRankCustomFieldService.getRankFields();
        LexoRankIntegrityResult result = new LexoRankIntegrityResult();
        for (CustomField rankField : rankFields) {
            LexoRankIntegrityCheckReport report = this.check(this.lexoRankIntegrityChecker.performFullIntegrityChecks(rankField));
            result.reports.add(report);
        }
        return Response.ok((Object)result).build();
    }

    public static class LexoRankBalanceResponse {
        public Collection<Long> balancingFieldIds;
    }

    public static class LexoRankBalanceStatus {
        public LexoRankBalancingService.LexoRankBalancingServiceStatus lexoRankBalancingServiceStatus;
        public LexoRankBalancer.LexoRankBalancerStatus lexoRankBalancerStatus;
        public Long totalIssueCount;
    }

    private static class LexoRankIntegrityResult {
        public List<LexoRankIntegrityCheckReport> reports = Lists.newArrayList();

        private LexoRankIntegrityResult() {
        }
    }

    private static class RankFieldDuplicateRanks {
        public String fieldName;
        public Long fieldId;
        public Map<String, Long> duplicateRanks;

        private RankFieldDuplicateRanks() {
        }
    }

    @XmlRootElement
    public static class LexoRankSuspendRequest
    extends RestTemplate {
        @XmlElement
        Boolean suspendBalancing = false;
    }
}

