/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.configuration;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancer;
import com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancingService;
import com.atlassian.greenhopper.web.configuration.LexoRankResource;
import com.atlassian.jira.component.ComponentAccessor;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankHelper {
    @Autowired
    private LexoRankBalancingService lexoRankBalancingService;
    @Autowired
    private LexoRankBalancer lexoRankBalancer;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;

    public LexoRankResource.LexoRankBalanceStatus getBalanceStatus() {
        LexoRankResource.LexoRankBalanceStatus lexoRankBalanceStatus = new LexoRankResource.LexoRankBalanceStatus();
        lexoRankBalanceStatus.lexoRankBalancingServiceStatus = this.lexoRankBalancingService.getBalanceStatus();
        lexoRankBalanceStatus.lexoRankBalancerStatus = this.lexoRankBalancer.getBalanceStatus(this.lexoRankCustomFieldService.getRankFields());
        lexoRankBalanceStatus.totalIssueCount = ComponentAccessor.getOfBizDelegator().getCount("Issue");
        return lexoRankBalanceStatus;
    }

    public ServiceOutcome<LexoRankResource.LexoRankBalanceResponse> requestFullBalance() {
        ServiceOutcome<Collection<Long>> serviceOutcome = this.lexoRankBalancingService.requestFullBalance();
        if (serviceOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(serviceOutcome);
        }
        LexoRankResource.LexoRankBalanceResponse result = new LexoRankResource.LexoRankBalanceResponse();
        result.balancingFieldIds = serviceOutcome.getValue();
        return ServiceOutcomeImpl.ok(result);
    }

    public ServiceOutcome<LexoRankResource.LexoRankBalanceResponse> requestBalance(Long fieldId) {
        ServiceOutcome<Collection<Long>> serviceOutcome = this.lexoRankBalancingService.requestBalance(fieldId);
        if (serviceOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(serviceOutcome);
        }
        LexoRankResource.LexoRankBalanceResponse result = new LexoRankResource.LexoRankBalanceResponse();
        result.balancingFieldIds = serviceOutcome.getValue();
        return ServiceOutcomeImpl.ok(result);
    }
}

