/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.configuration;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="configuration/jiraTask")
@Produces(value={"application/json"})
public class JiraTaskResource
extends AbstractResource {
    private PermissionService permissionService;
    private TaskManager taskManager;

    public JiraTaskResource(PermissionService permissionService, TaskManager taskManager) {
        this.permissionService = permissionService;
        this.taskManager = taskManager;
    }

    @GET
    @Path(value="{id}")
    public Response getMigrationStatus(final @PathParam(value="id") long id) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                TaskDescriptor task;
                ApplicationUser user = JiraTaskResource.this.getUser();
                if (!JiraTaskResource.this.permissionService.isJiraAdministrator(user)) {
                    JiraTaskResource.this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "You are not permitted to access this resource", new Object[0]));
                }
                if ((task = JiraTaskResource.this.taskManager.getTask(Long.valueOf(id))) == null) {
                    JiraTaskResource.this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "Could not find task with ID %d", id));
                    return null;
                }
                if (task.isFinished()) {
                    TaskStatus taskStatus = new TaskStatus((WorkflowMigrationResult)task.getResult());
                    return JiraTaskResource.this.createOkResponse(taskStatus);
                }
                TaskProgressEvent event = task.getTaskProgressIndicator().getLastProgressEvent();
                long progress = event == null ? 0L : event.getTaskProgress();
                TaskStatus taskStatus = new TaskStatus(progress);
                return JiraTaskResource.this.createOkResponse(taskStatus);
            }
        });
    }

    @XmlRootElement
    public static class TaskStatus
    extends RestTemplate {
        @XmlElement
        boolean finished;
        @XmlElement
        Long progress;
        @XmlElement
        Boolean successful;
        @XmlElement
        ErrorCollection errorCollection;
        @XmlElement
        Integer numberOfFailedIssues;
        @XmlElement
        List<String> failedIssues;

        public TaskStatus(WorkflowMigrationResult result) {
            this.finished = true;
            this.progress = null;
            this.successful = result.getResult() == 0;
            this.errorCollection = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection());
            this.numberOfFailedIssues = result.getNumberOfFailedIssues();
            this.failedIssues = ImmutableList.copyOf(result.getFailedIssues().values());
        }

        public TaskStatus(long progress) {
            this.finished = false;
            this.progress = progress;
            this.successful = null;
            this.errorCollection = null;
            this.numberOfFailedIssues = null;
            this.failedIssues = null;
        }
    }
}

