/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.configuration;

import com.atlassian.greenhopper.features.JiraSoftwareFeature;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.configuration.JiraSoftwareFeatureService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.jira.security.PermissionManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="configuration/features")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FeaturesResource
extends AbstractResource {
    private PermissionManager permissionManager;
    private JiraSoftwareFeatureService featuresService;

    public FeaturesResource(PermissionManager permissionManager, JiraSoftwareFeatureService featuresService) {
        this.permissionManager = permissionManager;
        this.featuresService = featuresService;
    }

    @PUT
    @Path(value="/parallelSprints/toggle")
    public Response toggleReleasePlanningBetaFeature(ToggleModel toggleModel) {
        return this.response(() -> {
            this.check(this.checkAdminPermission());
            this.featuresService.setFeatureEnabled(JiraSoftwareFeature.PARALLEL_SPRINTS, toggleModel.enable);
            return this.createNoContentResponse();
        });
    }

    private ServiceOutcome<Void> checkAdminPermission() {
        if (!this.permissionManager.hasPermission(0, this.getUser())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.error.permission.denied", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    @XmlRootElement
    static class ToggleModel {
        @XmlElement
        boolean enable;

        ToggleModel() {
        }
    }
}

