/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.configuration;

import com.atlassian.greenhopper.model.validation.JiraCopiedNotAuthorisedWebException;
import com.atlassian.greenhopper.service.GreenHopperCacheManager;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.jira.user.ApplicationUser;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="configuration/cache")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CacheControlResource
extends AbstractResource {
    private GreenHopperCacheManager greenHopperCacheManager;
    private PermissionService permissionService;

    public CacheControlResource(GreenHopperCacheManager greenHopperCacheManager, PermissionService permissionService) {
        this.greenHopperCacheManager = greenHopperCacheManager;
        this.permissionService = permissionService;
    }

    @GET
    @Path(value="/flushAll")
    public Response flushAll() {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = CacheControlResource.this.getUser();
                if (!CacheControlResource.this.permissionService.isJiraAdministrator(user)) {
                    CacheControlResource.this.log.warn("Action aborted: user [%s] tried to flush GreenHopper caches, but is not a JIRA administrator.", user.getName());
                    throw new JiraCopiedNotAuthorisedWebException();
                }
                CacheControlResource.this.greenHopperCacheManager.clearCaches(null);
                return Response.ok((Object)"GreenHopper caches flushed").build();
            }
        });
    }
}

