/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.conditions;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rapid.ProjectRapidViewService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectHasBoardsCondition
implements Condition {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectRapidViewService projectRapidViewService;
    private final ProjectService projectService;

    @Autowired
    @VisibleForTesting
    public ProjectHasBoardsCondition(JiraAuthenticationContext jiraAuthenticationContext, ProjectRapidViewService projectRapidViewService, ProjectService projectService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectRapidViewService = projectRapidViewService;
        this.projectService = projectService;
    }

    public void init(Map<String, String> parameters) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String projectKey = (String)context.get("projectKey");
        return this.projectHasBoards(projectKey);
    }

    private Option<Project> getProject(String projectKey) {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        return Option.option((Object)this.projectService.getProjectByKey(user, projectKey).getProject());
    }

    private boolean projectHasBoards(String projectKey) {
        ApplicationUser user;
        ServiceOutcome<List<RapidView>> boards;
        Option<Project> project = this.getProject(projectKey);
        if (project.isDefined() && (boards = this.projectRapidViewService.findRapidViewsByProject(user = this.jiraAuthenticationContext.getUser(), (Project)project.get())).isValid()) {
            return boards.getValue().size() > 0;
        }
        return false;
    }
}

