/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.conditions;

import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.upgrade.UpgradeVersionService;
import com.atlassian.greenhopper.web.conditions.AccessCheckMode;
import com.atlassian.greenhopper.web.conditions.GreenHopperConditionEvaluator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GreenHopperConditionEvaluatorImpl
implements GreenHopperConditionEvaluator {
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private UpgradeVersionService upgradeVersionService;

    @Override
    public boolean shouldDisplay(AccessCheckMode checkMode) {
        return this.verifyVersionIsKosher() && this.verifyLicense(checkMode);
    }

    private boolean verifyVersionIsKosher() {
        return this.upgradeVersionService.versionLooksKosher();
    }

    public boolean verifyLicense(AccessCheckMode checkMode) {
        return checkMode == AccessCheckMode.LICENSE ? this.isLicensed() : this.isValidUser();
    }

    private boolean isValidUser() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        return this.licenseService.isValidUser(user);
    }

    private boolean isLicensed() {
        return this.licenseService.isLicensed();
    }
}

