/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.api;

import com.atlassian.greenhopper.api.RemoteLinkCreateRequest;
import com.atlassian.greenhopper.api.entity.remotelink.sprint.RemoteSprintLink;
import com.atlassian.greenhopper.api.sprints.RemoteLinkedSprints;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.api.remote.RemoteLinkConversationService;
import com.atlassian.greenhopper.service.sprint.RemoteLinkedSprintMapper;
import com.atlassian.greenhopper.service.sprint.RemoteSprintLinkService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="api/sprints")
@Produces(value={"application/json", "application/xml"})
public class RemoteSprintLinkResource
extends AbstractResource {
    private final SprintService sprintService;
    private final RemoteSprintLinkService remoteSprintLinkService;
    private final RemoteLinkedSprintMapper remoteLinkedSprintMapper;
    private final RemoteLinkConversationService remoteLinkConversationService;
    private final LicenseService licenseService;
    private final I18nFactoryService i18nFactoryService;

    public RemoteSprintLinkResource(SprintService sprintService, RemoteSprintLinkService remoteSprintLinkService, RemoteLinkedSprintMapper remoteLinkedSprintMapper, RemoteLinkConversationService remoteLinkConversationService, LicenseService licenseService, I18nFactoryService i18nFactoryService) {
        this.sprintService = sprintService;
        this.remoteSprintLinkService = remoteSprintLinkService;
        this.remoteLinkedSprintMapper = remoteLinkedSprintMapper;
        this.remoteLinkConversationService = remoteLinkConversationService;
        this.licenseService = licenseService;
        this.i18nFactoryService = i18nFactoryService;
    }

    @POST
    @Path(value="{sprintId}/remotelink")
    public Response createOrUpdateRemoteSprintLink(final @PathParam(value="sprintId") Long sprintId, final RemoteLinkCreateRequest request) {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RemoteSprintLinkResource.this.getUser();
                RemoteSprintLinkResource.this.check(RemoteSprintLinkResource.this.remoteSprintLinkService.createRemoteSprintLink(user, sprintId, request.globalId, request.object.title, request.object.url, request.relationship, request.application.type, request.application.name));
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        });
    }

    @PUT
    @Path(value="{sprintId}/remotelinkchecked")
    @AnonymousAllowed
    public Response createRemoteSprintLinkChecked(final @PathParam(value="sprintId") Long sprintId, final RemoteLinkCreateRequest request) {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<RemoteLinkConversationService.CreationConversation> creationConversation = RemoteSprintLinkResource.this.remoteLinkConversationService.redeemConversation(request.creationToken);
                RemoteLinkConversationService.CreationConversation conversation = RemoteSprintLinkResource.this.check(creationConversation);
                ApplicationUser user = ApplicationUsers.byKey((String)conversation.getUserKey());
                RemoteSprintLinkResource.this.check(RemoteSprintLinkResource.this.remoteSprintLinkService.createRemoteSprintLink(user, sprintId, request.globalId, request.object.title, request.object.url, request.relationship, request.application.type, request.application.name));
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        });
    }

    @DELETE
    @Path(value="{sprintId}/remotelink/{linkId}")
    public Response deleteRemoteSprintLink(final @PathParam(value="sprintId") Long sprintId, final @PathParam(value="linkId") Long linkId) {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RemoteSprintLinkResource.this.getUser();
                Sprint sprint = RemoteSprintLinkResource.this.check(RemoteSprintLinkResource.this.sprintService.getSprint(user, sprintId));
                RemoteSprintLinkResource.this.remoteSprintLinkService.removeRemoteSprintLink(user, sprint, linkId);
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        });
    }

    @AnonymousAllowed
    @GET
    @Path(value="remotelink")
    public Response getRemoteLinkedSprints(final @QueryParam(value="globalId") List<String> globalIds) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RemoteSprintLinkResource.this.getUser();
                ArrayList remoteSprintLinks = Lists.newArrayList();
                for (String globalId : globalIds) {
                    ServiceOutcome<List<RemoteSprintLink>> linkedSprintsOutcome = RemoteSprintLinkResource.this.remoteSprintLinkService.getRemoteLinkedSprintsByGlobalId(globalId);
                    RemoteSprintLinkResource.this.check(linkedSprintsOutcome);
                    remoteSprintLinks.addAll((Collection)linkedSprintsOutcome.getValue());
                }
                ServiceOutcome<RemoteLinkedSprints> sprints = RemoteSprintLinkResource.this.remoteLinkedSprintMapper.mapList(user, remoteSprintLinks);
                RemoteSprintLinkResource.this.check(sprints);
                return Response.ok((Object)sprints.getValue()).build();
            }
        });
    }
}

