/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.api;

import com.atlassian.greenhopper.api.RemoteLinkCreateRequest;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.api.remote.RemoteLinkConversationService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="api/epics")
@Produces(value={"application/json", "application/xml"})
public class RemoteEpicLinkResource
extends AbstractResource {
    private final Pattern ISSUE_ID_PATTERN = Pattern.compile("^[1-9]\\d{0,17}$");
    private final RemoteIssueLinkService remoteIssueLinkService;
    private final RemoteLinkConversationService remoteLinkConversationService;
    private final IssueManager issueManager;

    public RemoteEpicLinkResource(RemoteIssueLinkService remoteIssueLinkService, RemoteLinkConversationService remoteLinkConversationService, IssueManager issueManager) {
        this.remoteIssueLinkService = remoteIssueLinkService;
        this.remoteLinkConversationService = remoteLinkConversationService;
        this.issueManager = issueManager;
    }

    @PUT
    @Path(value="{epicIdOrKey}/remotelinkchecked")
    @AnonymousAllowed
    public Response createEpicLinkChecked(final @PathParam(value="epicIdOrKey") String epicIdOrKey, final RemoteLinkCreateRequest request) {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                RemoteLinkConversationService.CreationConversation conversation = RemoteEpicLinkResource.this.check(RemoteEpicLinkResource.this.remoteLinkConversationService.redeemConversation(request.creationToken));
                ApplicationUser user = ApplicationUsers.byKey((String)conversation.getUserKey());
                MutableIssue epic = RemoteEpicLinkResource.this.isIssueId(epicIdOrKey) ? RemoteEpicLinkResource.this.issueManager.getIssueObject(Long.valueOf(Long.parseLong(epicIdOrKey))) : RemoteEpicLinkResource.this.issueManager.getIssueObject(epicIdOrKey);
                if (epic == null) {
                    RemoteEpicLinkResource.this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.remote.links.epic.not.found", epicIdOrKey));
                }
                RemoteIssueLink remoteEpicLink = new RemoteIssueLinkBuilder().issueId(epic.getId()).globalId(request.globalId).title(request.object.title).url(request.object.url).relationship(request.relationship).applicationType(request.application.type).applicationName(request.application.name).build();
                RemoteIssueLinkService.CreateValidationResult validationResult = RemoteEpicLinkResource.this.remoteIssueLinkService.validateCreate(user, remoteEpicLink);
                if (!validationResult.isValid()) {
                    RemoteEpicLinkResource.this.check(ServiceOutcomeImpl.from(validationResult.getErrorCollection(), ErrorCollection.Reason.VALIDATION_FAILED));
                } else {
                    RemoteIssueLinkService.RemoteIssueLinkResult remoteEpicLinkResult = RemoteEpicLinkResource.this.remoteIssueLinkService.create(user, validationResult);
                    if (!remoteEpicLinkResult.isValid()) {
                        RemoteEpicLinkResource.this.check(ServiceOutcomeImpl.from(remoteEpicLinkResult.getErrorCollection(), ErrorCollection.Reason.SERVER_ERROR));
                    }
                }
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
        });
    }

    private boolean isIssueId(String issueIdOrKey) {
        return this.ISSUE_ID_PATTERN.matcher(issueIdOrKey).matches();
    }
}

