/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.api;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.web.RankAfterRequest;
import com.atlassian.greenhopper.api.rank.web.RankBeforeRequest;
import com.atlassian.greenhopper.api.rank.web.RankResponse;
import com.atlassian.greenhopper.api.rank.web.Rankable;
import com.atlassian.greenhopper.api.rank.web.RankableChange;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RankableObject;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.model.validation.JiraCopiedNotFoundWebException;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rank.RankService;
import com.atlassian.greenhopper.service.rank.RankableFactory;
import com.atlassian.greenhopper.service.rank.RankableObjectService;
import com.atlassian.greenhopper.service.rank.RankableType;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rank-helper-external")
public class RankHelper {
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    @Autowired
    private RankService rankService;
    @Autowired
    private RankableObjectService rankableObjectService;
    @Autowired
    private IssueService issueService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private RankableFactory rankableFactory;

    public ServiceOutcome<RankChangesOutcome> rankBefore(RankBeforeRequest rankBeforeRequest) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        List<com.atlassian.greenhopper.api.rank.Rankable> rankables = this.validateCommonParameters(user, rankBeforeRequest.customFieldId, rankBeforeRequest.issueKeys, rankBeforeRequest.issueIds, rankBeforeRequest.rankables);
        com.atlassian.greenhopper.api.rank.Rankable rankBefore = this.validateSingleRankable(user, rankBeforeRequest.rankBeforeRankable, rankBeforeRequest.rankBeforeId, rankBeforeRequest.rankBeforeKey);
        return this.rankService.rankBefore(user, (long)rankBeforeRequest.customFieldId, rankables, rankBefore);
    }

    public ServiceOutcome<RankChangesOutcome> rankAfter(RankAfterRequest rankAfterRequest) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        List<com.atlassian.greenhopper.api.rank.Rankable> rankables = this.validateCommonParameters(user, rankAfterRequest.customFieldId, rankAfterRequest.issueKeys, rankAfterRequest.issueIds, rankAfterRequest.rankables);
        com.atlassian.greenhopper.api.rank.Rankable rankAfter = this.validateSingleRankable(user, rankAfterRequest.rankAfterRankable, rankAfterRequest.rankAfterId, rankAfterRequest.rankAfterKey);
        return this.rankService.rankAfter(user, (long)rankAfterRequest.customFieldId, rankables, rankAfter);
    }

    public String getIssueKey(Long issueId) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueId);
        return issueResult.isValid() ? issueResult.getIssue().getKey() : null;
    }

    public Response createRankResponse(RankChangesOutcome rankChanges) {
        RankResponse rankResponse = new RankResponse();
        rankResponse.rankableChanges = new ArrayList<RankableChange>();
        for (RankChange rankChange : rankChanges.getSuccessfulRankChanges()) {
            RankableChange change = new RankableChange();
            change.issueId = rankChange.getIssueId();
            change.issueKey = this.getIssueKey(rankChange.getIssueId());
            change.wasChanged = rankChange.wasChanged();
            rankResponse.rankableChanges.add(change);
        }
        Map<com.atlassian.greenhopper.api.rank.Rankable, com.atlassian.jira.util.ErrorCollection> errorCollections = rankChanges.getErrorCollections();
        for (com.atlassian.greenhopper.api.rank.Rankable rankable : errorCollections.keySet()) {
            RankableChange change = new RankableChange();
            change.issueId = rankable.getId();
            change.issueKey = this.getIssueKey(rankable.getId());
            change.wasChanged = false;
            change.errors = Lists.newArrayList(JiraCopiedRestErrorCollection.of(errorCollections.get(rankable)).getErrorMessages());
            rankResponse.rankableChanges.add(change);
        }
        return Response.ok((Object)rankResponse).build();
    }

    private com.atlassian.greenhopper.api.rank.Rankable validateSingleRankable(ApplicationUser user, Rankable rankAfterRankable, Long rankAfterId, String rankAfterKey) {
        if (rankAfterId != null) {
            return this.getRankableFromIssueId(user, rankAfterId);
        }
        if (rankAfterKey != null) {
            return this.getRankableFromIssueKey(user, rankAfterKey);
        }
        if (rankAfterRankable != null) {
            return this.unmarshallRankable(user, rankAfterRankable);
        }
        this.buildErrorAndThrow(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.after.required", new Object[0]);
        return null;
    }

    private List<com.atlassian.greenhopper.api.rank.Rankable> validateCommonParameters(ApplicationUser user, Long customFieldId, List<String> issueKeys, List<Long> issueIds, List<Rankable> rankableList) {
        if (customFieldId == null) {
            this.buildErrorAndThrow(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.custom.field.required", new Object[0]);
        }
        List<com.atlassian.greenhopper.api.rank.Rankable> rankables = null;
        if (issueIds != null && issueIds.size() > 0) {
            rankables = this.getRankablesByIssueId(user, issueIds);
        } else if (issueKeys != null && issueKeys.size() > 0) {
            rankables = this.getRankablesByIssueKey(user, issueKeys);
        } else if (rankableList != null && rankableList.size() > 0) {
            rankables = this.unmarshallRankables(user, rankableList);
        } else {
            this.buildErrorAndThrow(ErrorCollection.Reason.VALIDATION_FAILED, "gh.api.rank.error.issues.required", new Object[0]);
        }
        return rankables;
    }

    private List<com.atlassian.greenhopper.api.rank.Rankable> getRankablesByIssueId(ApplicationUser user, List<Long> issueIds) {
        return issueIds.stream().map(from -> this.getRankableFromIssueId(user, (Long)from)).collect(Collectors.toList());
    }

    private List<com.atlassian.greenhopper.api.rank.Rankable> getRankablesByIssueKey(ApplicationUser user, List<String> issueKeys) {
        return issueKeys.stream().map(from -> this.getRankableFromIssueKey(user, (String)from)).collect(Collectors.toList());
    }

    private List<com.atlassian.greenhopper.api.rank.Rankable> unmarshallRankables(ApplicationUser user, List<Rankable> markerIds) {
        return markerIds.stream().map(from -> this.unmarshallRankable(user, (Rankable)from)).collect(Collectors.toList());
    }

    private com.atlassian.greenhopper.api.rank.Rankable unmarshallRankable(ApplicationUser user, Rankable rankable) {
        ServiceOutcome<RankableObject> rankableNonIssue = this.rankableObjectService.getRankableObject(user, rankable.id);
        if (!rankableNonIssue.isValid()) {
            if (rankableNonIssue.getErrors().getReasons().contains((Object)ErrorCollection.Reason.NOT_FOUND)) {
                ErrorCollection newErrors = new ErrorCollection();
                newErrors.addError(ErrorCollection.Reason.NOT_FOUND, "gh.error.not.found", this.getI18n().getText(RankableType.getMessageKey(rankable.type)));
                ErrorCollections.checkErrors(newErrors, this.getI18n());
            } else {
                ErrorCollections.checkErrors(rankableNonIssue.getErrors(), this.getI18n());
            }
        }
        return this.rankableFactory.fromRankableObject(rankableNonIssue.getValue());
    }

    private com.atlassian.greenhopper.api.rank.Rankable getRankableFromIssueId(ApplicationUser user, Long id) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, id);
        return this.rankableFactory.fromIssue(this.validateGetIssue(issueResult));
    }

    private com.atlassian.greenhopper.api.rank.Rankable getRankableFromIssueKey(ApplicationUser user, String issueKey) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueKey);
        return this.rankableFactory.fromIssue(this.validateGetIssue(issueResult));
    }

    private Issue validateGetIssue(IssueService.IssueResult issueResult) {
        if (!issueResult.isValid()) {
            throw new JiraCopiedNotFoundWebException(JiraCopiedRestErrorCollection.of(issueResult.getErrorCollection()));
        }
        return issueResult.getIssue();
    }

    private I18n2 getI18n() {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        return loggedInUser != null ? this.i18nFactoryService.getI18n(loggedInUser) : this.i18nFactoryService.getI18n();
    }

    private void buildErrorAndThrow(ErrorCollection.Reason reason, String messageKey, Object ... params) {
        ErrorCollection errors = new ErrorCollection();
        errors.addError(reason, messageKey, params);
        ErrorCollections.checkErrors(errors, this.getI18n());
    }
}

