/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.api;

import com.atlassian.annotations.PublicApi;
import com.atlassian.greenhopper.api.issuetype.ManagedIssueTypesService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.api.ManagedIssueTypes;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="api/managed/issuetypes")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@AnonymousAllowed
@PublicApi
public class ManagedIssueTypesResource
extends AbstractResource {
    private final ManagedIssueTypesService managedIssueTypesService;

    public ManagedIssueTypesResource(ManagedIssueTypesService managedIssueTypesService) {
        this.managedIssueTypesService = managedIssueTypesService;
    }

    @GET
    public Response getDefaultValues() {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ManagedIssueTypes managedIssueTypes = new ManagedIssueTypes();
                managedIssueTypes.storyIssueType = ManagedIssueTypesResource.this.toJsonIssueType((ServiceOutcome<IssueType>)ManagedIssueTypesResource.this.managedIssueTypesService.getStoryIssueType());
                managedIssueTypes.epicIssueType = ManagedIssueTypesResource.this.toJsonIssueType((ServiceOutcome<IssueType>)ManagedIssueTypesResource.this.managedIssueTypesService.getEpicIssueType());
                return Response.ok((Object)managedIssueTypes).cacheControl(CacheControl.NO_CACHE).build();
            }
        });
    }

    private IssueTypeJsonBean toJsonIssueType(ServiceOutcome<IssueType> type) {
        if (!type.isValid()) {
            return null;
        }
        IssueType issueType = (IssueType)type.getReturnedValue();
        String self = null;
        return IssueTypeJsonBean.shortBean(self, (String)issueType.getId(), (String)issueType.getName(), (String)issueType.getDescription(), (boolean)issueType.isSubTask(), (String)issueType.getIconUrl());
    }
}

