/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.api;

import com.atlassian.annotations.PublicApi;
import com.atlassian.greenhopper.api.customfield.ManagedCustomFieldsService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.api.ManagedCustomFields;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.issue.FieldBean;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="api/managed/customfields")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@AnonymousAllowed
@PublicApi
public class ManagedCustomFieldsResource
extends AbstractResource {
    private final ManagedCustomFieldsService managedCustomFieldsService;
    private final FieldManager fieldManager;
    private final SearchHandlerManager searchHandlerManager;

    public ManagedCustomFieldsResource(ManagedCustomFieldsService managedCustomFieldsService, FieldManager fieldManager, SearchHandlerManager searchHandlerManager) {
        this.managedCustomFieldsService = managedCustomFieldsService;
        this.fieldManager = fieldManager;
        this.searchHandlerManager = searchHandlerManager;
    }

    @GET
    public Response getDefaultValues() {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ManagedCustomFields managedIssueTypes = new ManagedCustomFields();
                managedIssueTypes.storyPointsField = ManagedCustomFieldsResource.this.toFieldBean((ServiceOutcome<CustomField>)ManagedCustomFieldsResource.this.managedCustomFieldsService.getStoryPointsCustomField());
                managedIssueTypes.epicNameField = ManagedCustomFieldsResource.this.toFieldBean((ServiceOutcome<CustomField>)ManagedCustomFieldsResource.this.managedCustomFieldsService.getEpicNameCustomField());
                managedIssueTypes.epicLinkField = ManagedCustomFieldsResource.this.toFieldBean((ServiceOutcome<CustomField>)ManagedCustomFieldsResource.this.managedCustomFieldsService.getEpicLinkCustomField());
                managedIssueTypes.epicColorField = ManagedCustomFieldsResource.this.toFieldBean((ServiceOutcome<CustomField>)ManagedCustomFieldsResource.this.managedCustomFieldsService.getEpicColorCustomField());
                managedIssueTypes.epicStatusField = ManagedCustomFieldsResource.this.toFieldBean((ServiceOutcome<CustomField>)ManagedCustomFieldsResource.this.managedCustomFieldsService.getEpicStatusCustomField());
                managedIssueTypes.sprintField = ManagedCustomFieldsResource.this.toFieldBean((ServiceOutcome<CustomField>)ManagedCustomFieldsResource.this.managedCustomFieldsService.getSprintCustomField());
                managedIssueTypes.rankField = ManagedCustomFieldsResource.this.toFieldBean((ServiceOutcome<CustomField>)ManagedCustomFieldsResource.this.managedCustomFieldsService.getRankCustomField());
                return Response.ok((Object)managedIssueTypes).cacheControl(CacheControl.NO_CACHE).build();
            }
        });
    }

    private FieldBean toFieldBean(ServiceOutcome<CustomField> field) {
        if (!field.isValid()) {
            return null;
        }
        return FieldBean.shortBean((Field)((Field)field.getReturnedValue()), (FieldManager)this.fieldManager, (SearchHandlerManager)this.searchHandlerManager);
    }
}

