/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.api;

import com.atlassian.greenhopper.api.epics.CustomFieldModel;
import com.atlassian.greenhopper.api.epics.CustomFieldOptionModel;
import com.atlassian.greenhopper.api.epics.EpicPropertiesModel;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import io.atlassian.fugue.Option;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="api/epicproperties")
@AnonymousAllowed
@Produces(value={"application/json", "application/xml"})
public class EpicPropertiesResource
extends AbstractResource {
    private IssueTypeService issueTypeService;
    private EpicCustomFieldService epicCustomFieldService;

    public EpicPropertiesResource(IssueTypeService issueTypeService, EpicCustomFieldService epicCustomFieldService) {
        this.issueTypeService = issueTypeService;
        this.epicCustomFieldService = epicCustomFieldService;
    }

    @GET
    public Response getEpicProperties() {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                EpicPropertiesModel epicProperties = new EpicPropertiesModel();
                epicProperties.epicTypeId = EpicPropertiesResource.this.issueTypeService.getIssueTypeId(IssueTypePrototype.EPIC);
                CustomField epicNameField = EpicPropertiesResource.this.epicCustomFieldService.getDefaultEpicLabelField();
                CustomFieldModel epicNameModel = new CustomFieldModel();
                epicNameModel.id = epicNameField.getIdAsLong();
                epicNameModel.name = epicNameField.getName();
                epicProperties.epicNameField = epicNameModel;
                CustomField epicStatusField = EpicPropertiesResource.this.epicCustomFieldService.getDefaultEpicStatusField();
                CustomFieldModel epicStatusModel = new CustomFieldModel();
                epicStatusModel.id = epicStatusField.getIdAsLong();
                epicStatusModel.name = epicStatusField.getName();
                epicProperties.epicStatusField = epicStatusModel;
                Option<com.atlassian.jira.issue.customfields.option.Option> doneEpicStatusOption = EpicPropertiesResource.this.epicCustomFieldService.getDoneEpicStatusOption();
                if (!doneEpicStatusOption.isEmpty()) {
                    com.atlassian.jira.issue.customfields.option.Option doneOption = (com.atlassian.jira.issue.customfields.option.Option)doneEpicStatusOption.get();
                    CustomFieldOptionModel optionModel = new CustomFieldOptionModel();
                    optionModel.id = doneOption.getOptionId();
                    optionModel.val = doneOption.getValue();
                    epicProperties.epicDoneStatus = optionModel;
                }
                return Response.ok((Object)epicProperties).build();
            }
        });
    }
}

