/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.admin;

import com.atlassian.greenhopper.events.feature.FeatureEventPublisher;
import com.atlassian.greenhopper.features.JiraSoftwareFeature;
import com.atlassian.greenhopper.service.configuration.JiraSoftwareFeatureService;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.greenhopper.web.admin.GlobalAdminConditionEvaluator;
import com.atlassian.greenhopper.web.admin.SoftwareConfigConditionEvaluator;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

@WebSudoRequired
public class SoftwareConfigAction
extends GreenHopperWebActionSupport {
    @Autowired
    GlobalAdminConditionEvaluator globalAdminConditionEvaluator;
    @Autowired
    JiraSoftwareFeatureService featureService;
    @Autowired
    PageBuilderService pageBuilderService;
    @Autowired
    SoftwareConfigConditionEvaluator softwareConfigConditionEvaluator;
    @Autowired
    private FeatureEventPublisher featureEventPublisher;

    public String doGet() {
        if (this.isPageAccessible()) {
            this.pageBuilderService.assembler().resources().requireWebResource("com.pyxis.greenhopper.jira:gh-admin-software-config");
            return "gh-admin-software-config-view";
        }
        return "error";
    }

    @ActionViewData
    public List<Map<String, Object>> getFeatures() {
        return Stream.of(JiraSoftwareFeature.values()).map(this::feature2Map).collect(Collectors.toList());
    }

    private Map<String, Object> feature2Map(JiraSoftwareFeature feature) {
        String title = this.getText("gh.configuration.features." + feature.name() + ".title");
        String description = this.getText("gh.configuration.features." + feature.name() + ".description");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", feature.name());
        result.put("labelText", title);
        result.put("descriptionText", description);
        result.put("isChecked", this.featureService.isFeatureEnabled(feature));
        return result;
    }

    @RequiresXsrfCheck
    public String doSetFeatureEnabled() {
        String featureId = this.getHttpRequest().getParameter("featureId");
        boolean newValue = Boolean.parseBoolean(this.getHttpRequest().getParameter("newValue"));
        JiraSoftwareFeature feature = JiraSoftwareFeature.valueFor(featureId);
        if (!this.isPageAccessible()) {
            return "error";
        }
        if (feature == null) {
            this.log.warn((Object)("Unknown feature received: " + featureId));
            return "error";
        }
        this.featureService.setFeatureEnabled(feature, newValue);
        this.featureEventPublisher.publishFeatureToggledEvent(feature.getKey(), newValue);
        return "success";
    }

    boolean isPageAccessible() {
        return this.globalAdminConditionEvaluator.evaluate() && this.softwareConfigConditionEvaluator.evaluate();
    }
}

