/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.admin;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.greenhopper.license.JiraForSoftwareChecker;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.license.SoftwareAuthorizationService;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GlobalAdminConditionEvaluator {
    private final SoftwareAuthorizationService softwareAuthorizationService;
    private final JiraForSoftwareChecker jiraForSoftwareChecker;
    private final LicenseService licenseService;

    @Autowired
    public GlobalAdminConditionEvaluator(SoftwareAuthorizationService softwareAuthorizationService, JiraForSoftwareChecker jiraForSoftwareChecker, LicenseService licenseService) {
        this.softwareAuthorizationService = softwareAuthorizationService;
        this.jiraForSoftwareChecker = jiraForSoftwareChecker;
        this.licenseService = licenseService;
    }

    public boolean evaluate() {
        boolean checkResult = this.jiraForSoftwareChecker.isJiraForSoftwareSupported() ? this.checkLicenseIsValidIgnoringUserCount() : this.licenseService.isLicensed();
        return checkResult;
    }

    private boolean checkLicenseIsValidIgnoringUserCount() {
        Collection<ApplicationAccess.AccessError> applicationAccessErrors = this.softwareAuthorizationService.getSoftwareLicensingAccessErrors();
        return !applicationAccessErrors.contains(ApplicationAccess.AccessError.UNLICENSED) && !applicationAccessErrors.contains(ApplicationAccess.AccessError.EXPIRED) && !applicationAccessErrors.contains(ApplicationAccess.AccessError.VERSION_MISMATCH);
    }
}

