/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.admin;

import com.atlassian.greenhopper.features.LabsFeature;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.greenhopper.web.admin.GlobalAdminConditionEvaluator;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@WebSudoRequired
public class AgileLabsAdminAction
extends GreenHopperWebActionSupport {
    private static final String COMPLETE_WEB_RESOURCE_KEY = "com.pyxis.greenhopper.jira:gh-admin-labs";
    private static final String VIEW = "gh-admin-labs-config-view";
    private static final String NOT_FOUND = "404";
    private final GlobalAdminConditionEvaluator globalAdminConditionEvaluator;
    private final FeatureManager featureManager;
    private final PageBuilderService pageBuilderService;
    private String featureId;
    private boolean newValue;

    public AgileLabsAdminAction(GlobalAdminConditionEvaluator globalAdminConditionEvaluator, FeatureManager featureManager, PageBuilderService pageBuilderService) {
        this.globalAdminConditionEvaluator = globalAdminConditionEvaluator;
        this.featureManager = featureManager;
        this.pageBuilderService = pageBuilderService;
    }

    public String doGet() {
        this.pageBuilderService.assembler().resources().requireWebResource(COMPLETE_WEB_RESOURCE_KEY);
        return this.isPageAccessible() ? VIEW : NOT_FOUND;
    }

    @ActionViewData
    public List<Map<String, Object>> getFeatures() {
        return Stream.of(LabsFeature.values()).map(this::featureToMap).collect(Collectors.toList());
    }

    private Map<String, Object> featureToMap(LabsFeature feature) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", feature.getDarkFeatureKey());
        result.put("labelText", this.getText(feature.getI18nTitle()));
        result.put("descriptionText", this.getText(feature.getI18nDescription()));
        result.put("isChecked", this.isFeatureEnabled(feature));
        String disableFeatureConfirmMessage = this.getText(feature.getI18nDisableConfirmMessage());
        result.put("extraAttributes", !Strings.isNullOrEmpty((String)disableFeatureConfirmMessage) ? String.format("data-confirm-disable-message='%s'", disableFeatureConfirmMessage) : "");
        return result;
    }

    @RequiresXsrfCheck
    public String doSetLabs() {
        if (this.isPageAccessible()) {
            if (this.isLabsFeature(this.featureId)) {
                if (this.newValue) {
                    this.featureManager.enableSiteDarkFeature(this.featureId);
                } else {
                    this.featureManager.disableSiteDarkFeature(this.featureId);
                }
            } else {
                this.log.warn((Object)("Unknkown labs feature received: " + this.featureId));
            }
        }
        return "success";
    }

    @VisibleForTesting
    boolean isLabsFeature(String featureKey) {
        return Arrays.stream(LabsFeature.values()).anyMatch(feature -> feature.getDarkFeatureKey().equals(featureKey));
    }

    private boolean isFeatureEnabled(LabsFeature feature) {
        return this.featureManager.getDarkFeatures().getSiteEnabledFeatures().contains(feature.getDarkFeatureKey());
    }

    private boolean isPageAccessible() {
        return this.featureManager.isOnDemand() && this.globalAdminConditionEvaluator.evaluate();
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public void setNewValue(boolean newValue) {
        this.newValue = newValue;
    }
}

