/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web;

import com.atlassian.greenhopper.event.mau.MauEventServiceBridge;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.util.RestCall;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResource {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    public static final String HTTP_HEADER_GREENHOPPER_GADGET = "X-Atlassian-GreenHopper-Gadget";
    protected JiraAuthenticationContext authenticationContext;
    private I18nFactoryService i18nFactoryService;
    private LicenseService licenseService;
    private MauEventServiceBridge mauEventServiceBridge;
    @Context
    private HttpHeaders httpHeaders;

    @Autowired
    public void wireI18nFactoryService(I18nFactoryService i18nFactoryService) {
        this.i18nFactoryService = i18nFactoryService;
    }

    @Autowired
    public void wireAuthenticationContext(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Autowired
    public void wireLicenseChecker(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @Autowired
    public void wireMauEventServiceBridge(MauEventServiceBridge mauEventServiceBridge) {
        this.mauEventServiceBridge = mauEventServiceBridge;
    }

    protected Response response(Callable<Response> responseCallable) {
        ApplicationUser user = this.authenticationContext.getUser();
        if (!this.licenseService.isValidUser(user)) {
            return this.createNoAccessResponse(user);
        }
        return this.createResponse(responseCallable);
    }

    protected Response responseWithoutAccessCheck(Callable<Response> responseCallable) {
        return this.createResponse(responseCallable);
    }

    private Response createResponse(Callable<Response> responseCallable) {
        this.mauEventServiceBridge.tagCurrentRequestAsJIRASoftware();
        return new RestCall(this.getClass()).response(responseCallable);
    }

    private Response createNoAccessResponse(ApplicationUser user) {
        String error = this.i18nFactoryService.getI18n(user).getText("gh.license.no.access");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)JiraCopiedRestErrorCollection.of(error)).cacheControl(CacheControl.NO_CACHE).build();
    }

    public Response createOkResponse(RestTemplate entity) {
        return Response.ok((Object)entity).cacheControl(CacheControl.NO_CACHE).build();
    }

    public Response createOkResponse(RestTemplate template, EntityTag eTag) {
        return Response.ok((Object)template).tag(eTag).build();
    }

    public Response createNoContentResponse() {
        return Response.noContent().cacheControl(CacheControl.NO_CACHE).build();
    }

    public <T> T check(ServiceOutcome<T> outcome) {
        if (outcome.isInvalid()) {
            this.checkErrors(outcome.getErrors());
        }
        return outcome.getValue();
    }

    public void checkResult(ServiceResult result) {
        if (result.isInvalid()) {
            this.checkErrors(result.getErrors());
        }
    }

    private void checkErrors(ErrorCollection errors) {
        ErrorCollections.checkErrors(errors, this.i18nFactoryService.getI18n(this.authenticationContext.getUser()));
    }

    protected <T> Set<T> nullSafe(Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    protected ApplicationUser getUser() {
        return this.authenticationContext.getUser();
    }

    protected boolean isGadgetRequest() {
        List requestHeader = this.httpHeaders.getRequestHeader(HTTP_HEADER_GREENHOPPER_GADGET);
        if (requestHeader != null) {
            for (String s : requestHeader) {
                if (!Boolean.TRUE.toString().equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }
}

