/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.lucene;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;

public class LimitedStoredFieldVisitor
extends DocumentStoredFieldVisitor {
    protected int loaded;
    protected String lastField;
    private static final Set<String> COMMON_FIELDS = ImmutableSet.of((Object)"key", (Object)"issue_id");
    private final int numberOfFieldsToLoad;
    private final Set<String> fieldNames;

    public LimitedStoredFieldVisitor(Set<String> fieldNames) {
        this.fieldNames = ImmutableSet.builder().addAll(COMMON_FIELDS).addAll(fieldNames).build();
        this.numberOfFieldsToLoad = this.fieldNames.size();
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        String fieldName = fieldInfo.name;
        if (this.fieldNames.contains(fieldName)) {
            if (this.lastField == null || !this.lastField.equals(fieldName)) {
                ++this.loaded;
                this.lastField = fieldName;
            }
            return StoredFieldVisitor.Status.YES;
        }
        return this.loaded == this.numberOfFieldsToLoad ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }
}

