/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.jql.project;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.ProjectResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectValuesProvider {
    private static final LoggerWrapper log = LoggerWrapper.with(ProjectValuesProvider.class);
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private JqlOperandResolver jqlOperandResolver;

    public Set<Project> getValues(ApplicationUser user, TerminalClause clause) {
        List<QueryLiteral> values = this.getClauseValues(user, clause);
        return values.stream().flatMap(literal -> this.getValue((QueryLiteral)literal).stream()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Collection<Project> getValue(QueryLiteral literal) {
        if (literal.getStringValue() != null) {
            String stringValue = literal.getStringValue();
            return this.getProjectsFromNameOrKey(stringValue);
        }
        if (literal.getLongValue() != null) {
            Long longValue = literal.getLongValue();
            return Collections.singletonList(this.projectManager.getProjectObj(longValue));
        }
        if (literal.isEmpty()) {
            return Collections.emptyList();
        }
        throw new IllegalStateException("Invalid query literal");
    }

    private Collection<Project> getProjectsFromNameOrKey(String nameOrKey) {
        List ids = ((ProjectResolver)ComponentAccessor.getComponent(ProjectResolver.class)).getIdsFromName(nameOrKey);
        return ids.stream().map(Long::valueOf).map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).collect(Collectors.toList());
    }

    private List<QueryLiteral> getClauseValues(ApplicationUser user, TerminalClause clause) {
        try {
            return this.jqlOperandResolver.getValues(user, clause.getOperand(), clause);
        }
        catch (Exception exception) {
            log.warn(String.format("Failed to fetch data from clause (%s) for user %s", clause, user), exception);
            return Collections.emptyList();
        }
    }
}

