/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.jql.project;

import com.atlassian.greenhopper.util.jql.project.OperatorsUtil;
import com.atlassian.greenhopper.util.jql.project.ProjectTerminalClause;
import com.atlassian.jira.project.Project;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operator.Operator;

public class ProjectSatisfiesQueryVisitor
implements ClauseVisitor<Boolean> {
    private final Project project;

    ProjectSatisfiesQueryVisitor(Project project) {
        this.project = project;
    }

    public Boolean visit(AndClause andClause) {
        return !andClause.getClauses().stream().anyMatch(clause -> (Boolean)clause.accept((ClauseVisitor)this) == false);
    }

    public Boolean visit(NotClause notClause) {
        throw new IllegalStateException("We have removed all the NOT clauses from the query, this should never occur.");
    }

    public Boolean visit(OrClause orClause) {
        return orClause.getClauses().stream().anyMatch(clause -> (Boolean)clause.accept((ClauseVisitor)this));
    }

    public Boolean visit(TerminalClause clause) {
        if (clause instanceof ProjectTerminalClause) {
            ProjectTerminalClause projectTerminalClause = (ProjectTerminalClause)clause;
            boolean isEqual = projectTerminalClause.getProjects().contains(this.project);
            Operator operator = projectTerminalClause.getOperator();
            if (OperatorsUtil.isEqualityOperator(operator)) {
                return isEqual;
            }
            if (OperatorsUtil.isNotEqualityOperator(operator)) {
                return !isEqual;
            }
        }
        throw new IllegalStateException("We have removed all the not Project Terminal clauses from the query, this should never occur.");
    }

    public Boolean visit(WasClause clause) {
        throw new IllegalStateException("We have removed all the WAS clauses from the query, this should never occur.");
    }

    public Boolean visit(ChangedClause clause) {
        throw new IllegalStateException("We have removed all the CHANGED clauses from the query, this should never occur.");
    }
}

