/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.jql.project;

import com.atlassian.greenhopper.util.jql.project.OperatorsUtil;
import com.atlassian.greenhopper.util.jql.project.ProjectSatisfiesQueryVisitor;
import com.atlassian.greenhopper.util.jql.project.ProjectTerminalClause;
import com.atlassian.greenhopper.util.jql.project.ProjectValuesProvider;
import com.atlassian.jira.jql.clause.DeMorgansVisitor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ProjectContextVisitor
implements ClauseVisitor<Clause> {
    private static final String PROJECT_CLAUSE_NAME = "project";
    private final ApplicationUser user;
    private final ProjectValuesProvider projectValuesProvider;
    private final ImmutableSet.Builder<Project> projectsSetBuilder = ImmutableSet.builder();
    private boolean isResultUserContextIndependent = true;
    private Clause projectClause;

    public ProjectContextVisitor(ApplicationUser user, ProjectValuesProvider projectValuesProvider) {
        this.user = user;
        this.projectValuesProvider = projectValuesProvider;
    }

    public Clause visit(AndClause andClause) {
        return this.processRootClause((Clause)andClause);
    }

    public Clause visit(NotClause notClause) {
        return this.processRootClause((Clause)notClause);
    }

    public Clause visit(OrClause orClause) {
        return this.processRootClause((Clause)orClause);
    }

    public Clause visit(TerminalClause clause) {
        return this.processRootClause((Clause)clause);
    }

    public Clause visit(WasClause clause) {
        return null;
    }

    public Clause visit(ChangedClause clause) {
        return null;
    }

    public Set<Long> getProjectIds() {
        ImmutableSet projects = this.projectsSetBuilder.build();
        return projects.stream().filter(project -> (Boolean)this.projectClause.accept((ClauseVisitor)new ProjectSatisfiesQueryVisitor((Project)project))).map(Project::getId).collect(Collectors.toCollection(() -> ProjectContextVisitor.lambda$getProjectIds$1((Set)projects)));
    }

    public boolean isResultUserContextIndependent() {
        return this.isResultUserContextIndependent;
    }

    private boolean isProjectClause(Clause clause) {
        return PROJECT_CLAUSE_NAME.equalsIgnoreCase(clause.getName());
    }

    private Clause processRootClause(Clause clause) {
        Clause normalisedClause = (Clause)clause.accept((ClauseVisitor)new DeMorgansVisitor());
        this.projectClause = (Clause)normalisedClause.accept((ClauseVisitor)new InnerProjectContextVisitor());
        return this.projectClause;
    }

    private static /* synthetic */ HashSet lambda$getProjectIds$1(Set projects) {
        return new HashSet(projects.size());
    }

    private class InnerProjectContextVisitor
    implements ClauseVisitor<Clause> {
        private InnerProjectContextVisitor() {
        }

        public Clause visit(AndClause andClause) {
            List<Clause> projectChildClauses = this.visitInternal((Clause)andClause);
            return !projectChildClauses.isEmpty() ? new AndClause(projectChildClauses) : null;
        }

        public Clause visit(NotClause notClause) {
            throw new IllegalStateException("We have removed all the NOT clauses from the query, this should never occur.");
        }

        public Clause visit(OrClause orClause) {
            List<Clause> projectChildClauses = this.visitInternal((Clause)orClause);
            return !projectChildClauses.isEmpty() ? new OrClause(projectChildClauses) : null;
        }

        public Clause visit(TerminalClause clause) {
            Operator operator = clause.getOperator();
            if (ProjectContextVisitor.this.isProjectClause((Clause)clause) && (OperatorsUtil.isEqualityOperator(operator) || OperatorsUtil.isNotEqualityOperator(operator))) {
                Set<Project> projects = ProjectContextVisitor.this.projectValuesProvider.getValues(ProjectContextVisitor.this.user, clause);
                Operand operand = clause.getOperand();
                if (operand instanceof FunctionOperand) {
                    ProjectContextVisitor.this.isResultUserContextIndependent = false;
                }
                if (OperatorsUtil.isEqualityOperator(operator)) {
                    ProjectContextVisitor.this.projectsSetBuilder.addAll(projects);
                }
                return new ProjectTerminalClause(clause, projects);
            }
            return null;
        }

        public Clause visit(WasClause clause) {
            return null;
        }

        public Clause visit(ChangedClause clause) {
            return null;
        }

        private List<Clause> visitInternal(Clause clause) {
            List childClauses = clause.getClauses();
            return childClauses.stream().map(childClause -> (Clause)childClause.accept((ClauseVisitor)this)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new ArrayList(childClauses.size())));
        }
    }
}

