/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.jql;

import com.atlassian.greenhopper.util.jql.DeterminedProjectsInQueryVisitor;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;

public class VersionsFunctionOptimizer {
    private final VersionsFunctionOptimizerVisitor versionsFunctionOptimizerVisitor;

    public VersionsFunctionOptimizer(VersionsFunctionOptimizerVisitor versionsFunctionOptimizerVisitor) {
        this.versionsFunctionOptimizerVisitor = versionsFunctionOptimizerVisitor;
    }

    public Query createOptimizedQuery(Query query) {
        DeterminedProjectsInQueryVisitor determinedProjectsInQueryVisitor = new DeterminedProjectsInQueryVisitor();
        Clause whereClause = query.getWhereClause();
        if (whereClause != null && ((Boolean)whereClause.accept((ClauseVisitor)determinedProjectsInQueryVisitor)).booleanValue()) {
            Set<String> determinedProjects = determinedProjectsInQueryVisitor.getDeterminedProjects();
            Clause optimizedWhereClause = (Clause)whereClause.accept((ClauseVisitor)new ClauseRebuildingOptimizer(determinedProjects));
            return new QueryImpl(optimizedWhereClause, query.getOrderByClause(), null);
        }
        return query;
    }

    private class ClauseRebuildingOptimizer
    implements ClauseVisitor<Clause> {
        private final Set<String> projects;

        private ClauseRebuildingOptimizer(Set<String> projects) {
            this.projects = projects;
        }

        public Clause visit(AndClause andClause) {
            ImmutableList.Builder rebuiltClauses = ImmutableList.builder();
            for (Clause clause : andClause.getClauses()) {
                rebuiltClauses.add(clause.accept((ClauseVisitor)this));
            }
            return new AndClause((Collection)rebuiltClauses.build());
        }

        public Clause visit(NotClause notClause) {
            return new NotClause((Clause)notClause.getSubClause().accept((ClauseVisitor)this));
        }

        public Clause visit(OrClause orClause) {
            ImmutableList.Builder rebuiltClauses = ImmutableList.builder();
            for (Clause clause : orClause.getClauses()) {
                rebuiltClauses.add(clause.accept((ClauseVisitor)this));
            }
            return new OrClause((Collection)rebuiltClauses.build());
        }

        public Clause visit(TerminalClause clause) {
            if (((Boolean)clause.getOperand().accept((OperandVisitor)VersionsFunctionOptimizer.this.versionsFunctionOptimizerVisitor)).booleanValue()) {
                return VersionsFunctionOptimizer.this.versionsFunctionOptimizerVisitor.optimizeClause(clause, this.projects.toArray(new String[this.projects.size()]));
            }
            return clause;
        }

        public Clause visit(WasClause clause) {
            return clause;
        }

        public Clause visit(ChangedClause clause) {
            return clause;
        }
    }

    static abstract class VersionsFunctionOptimizerVisitor
    implements OperandVisitor<Boolean> {
        VersionsFunctionOptimizerVisitor() {
        }

        public Boolean visit(EmptyOperand emptyOperand) {
            return false;
        }

        public Boolean visit(MultiValueOperand multiValueOperand) {
            return false;
        }

        public Boolean visit(SingleValueOperand singleValueOperand) {
            return false;
        }

        public abstract TerminalClause optimizeClause(TerminalClause var1, String[] var2);
    }
}

