/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.jql;

import com.atlassian.greenhopper.util.jql.VersionsFunctionOptimizer;
import com.atlassian.query.Query;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;

public class UnreleasedVersionsFunctionOptimizer {
    public Query createOptimizedQuery(Query query) {
        VersionsFunctionOptimizer optimizer = new VersionsFunctionOptimizer(new UnreleasedVersionsFunctionVisitorVisitor());
        return optimizer.createOptimizedQuery(query);
    }

    private static class UnreleasedVersionsFunctionVisitorVisitor
    extends VersionsFunctionOptimizer.VersionsFunctionOptimizerVisitor {
        private UnreleasedVersionsFunctionVisitorVisitor() {
        }

        @Override
        public TerminalClause optimizeClause(TerminalClause clause, String[] arguments) {
            if (((Boolean)clause.getOperand().accept((OperandVisitor)new UnreleasedVersionsFunctionVisitorVisitor())).booleanValue()) {
                FunctionOperand optimizedOperand = new FunctionOperand("unreleasedVersions", arguments);
                return new TerminalClauseImpl(clause.getName(), clause.getOperator(), (Operand)optimizedOperand);
            }
            return clause;
        }

        public Boolean visit(FunctionOperand functionOperand) {
            return "unreleasedVersions".equalsIgnoreCase(functionOperand.getName()) && functionOperand.getArgs().size() == 0;
        }
    }
}

