/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.jql;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicsQueryHelper {
    private final RapidViewQueryService rapidViewQueryService;
    private final IssueTypeService issueTypeService;

    @Autowired
    public EpicsQueryHelper(RapidViewQueryService rapidViewQueryService, IssueTypeService issueTypeService) {
        this.rapidViewQueryService = rapidViewQueryService;
        this.issueTypeService = issueTypeService;
    }

    public ServiceOutcome<JqlQueryBuilder> getEpicsQuery(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (rapidViewQuery.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        IssueType epicIssues = this.issueTypeService.getOrCreateEpicIssueType();
        JqlQueryBuilder epics = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where().defaultAnd().issueType(new String[]{epicIssues.getName()}).endWhere();
        return ServiceOutcomeImpl.ok(epics);
    }
}

