/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.jql;

import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DeterminedProjectsInQueryVisitor
implements ClauseVisitor<Boolean> {
    public static final String PROJECT_CLAUSE_NAME = "project";
    public static final ImmutableList<Operator> ALLOWED_OPERATORS = ImmutableList.of((Object)Operator.EQUALS, (Object)Operator.IN, (Object)Operator.IS);
    public final ImmutableSet.Builder<String> projectsSetBuilder = ImmutableSet.builder();

    public Boolean visit(AndClause andClause) {
        boolean atLeastOneSubVisit = false;
        for (Clause clause : andClause.getClauses()) {
            atLeastOneSubVisit |= ((Boolean)clause.accept((ClauseVisitor)this)).booleanValue();
        }
        return atLeastOneSubVisit;
    }

    public Boolean visit(OrClause orClause) {
        boolean allSubVisits = true;
        for (Clause clause : orClause.getClauses()) {
            allSubVisits &= ((Boolean)clause.accept((ClauseVisitor)this)).booleanValue();
        }
        return allSubVisits;
    }

    public Boolean visit(TerminalClause terminalClause) {
        if (PROJECT_CLAUSE_NAME.equalsIgnoreCase(terminalClause.getName()) && ALLOWED_OPERATORS.contains((Object)terminalClause.getOperator())) {
            List extractedProjects = (List)terminalClause.getOperand().accept((OperandVisitor)new ArgumentExtractingOperandVisitor());
            this.addAllWithQuotationMarksRemoved(extractedProjects);
            return extractedProjects.size() > 0;
        }
        return false;
    }

    public Boolean visit(WasClause wasClause) {
        return false;
    }

    public Boolean visit(ChangedClause changedClause) {
        return false;
    }

    public Boolean visit(NotClause notClause) {
        return false;
    }

    public Set<String> getDeterminedProjects() {
        return this.projectsSetBuilder.build();
    }

    private void addAllWithQuotationMarksRemoved(Iterable<String> projects) {
        for (String project : projects) {
            this.projectsSetBuilder.add((Object)project.replaceAll("\"", ""));
        }
    }

    private static class ArgumentExtractingOperandVisitor
    implements OperandVisitor<List<String>> {
        private ArgumentExtractingOperandVisitor() {
        }

        public List<String> visit(EmptyOperand emptyOperand) {
            return Collections.emptyList();
        }

        public List<String> visit(FunctionOperand functionOperand) {
            return Collections.emptyList();
        }

        public List<String> visit(MultiValueOperand multiValueOperand) {
            Iterable operands = Iterables.transform((Iterable)multiValueOperand.getValues(), (Function)new Function<Operand, String>(){

                public String apply(Operand input) {
                    return input.getDisplayString();
                }
            });
            return ImmutableList.copyOf((Iterable)operands);
        }

        public List<String> visit(SingleValueOperand singleValueOperand) {
            return ImmutableList.of((Object)singleValueOperand.getDisplayString());
        }
    }
}

