/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.database;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.util.database.DatabaseUtils;
import com.atlassian.jira.database.ConnectionFunction;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseConnection;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupportedDatabaseChecker {
    @Autowired
    private DatabaseAccessor databaseAccessor;
    private static final LoggerWrapper LOG = LoggerWrapper.with(SupportedDatabaseChecker.class);

    public void check() {
        this.databaseAccessor.executeQuery((ConnectionFunction)new ConnectionFunction<Void>(){

            public Void run(DatabaseConnection databaseConnection) {
                try {
                    switch (DatabaseUtils.resolveDatabaseType(databaseConnection.getJdbcConnection())) {
                        case ORACLE_10g: {
                            SupportedDatabaseChecker.this.logWarning();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private void logWarning() {
        StringBuilder message = new StringBuilder();
        message.append("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        message.append("\nJIRA is connected to an unsupported database. Please upgrade to a supported version to avoid incompatibility issues");
        message.append("\n   See https://confluence.atlassian.com/display/JIRA/Supported+Platforms");
        message.append("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        LOG.warn(message.toString(), new Object[0]);
    }
}

