/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.database;

import com.atlassian.greenhopper.util.database.DatabaseType;
import java.sql.Connection;
import java.sql.SQLException;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public class DatabaseUtils {
    public static DatabaseType resolveDatabaseType(Connection connection) throws SQLException {
        String databaseTypeName = DatabaseTypeFactory.getTypeForConnection((Connection)connection).getFieldTypeName();
        int databaseMajorVersion = connection.getMetaData().getDatabaseMajorVersion();
        int databaseMinorVersion = connection.getMetaData().getDatabaseMinorVersion();
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (!databaseType.matchesIdentifierAndMajorVersionAndMinorVersion(databaseTypeName, databaseMajorVersion, databaseMinorVersion)) continue;
            return databaseType;
        }
        throw new IllegalArgumentException("Could not resolve database type from given connection");
    }
}

