/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util.database;

import com.atlassian.greenhopper.util.database.DatabaseFamily;

public enum DatabaseType {
    HSQL("hsql", DatabaseFamily.HSQL),
    H2("h2", DatabaseFamily.HSQL),
    MYSQL("mysql", DatabaseFamily.MYSQL),
    POSTGRESQL_8("postgres", 8, DatabaseFamily.POSTGRES),
    POSTGRESQL_9_0("postgres", 9, 0, DatabaseFamily.POSTGRES),
    POSTGRESQL("postgres", DatabaseFamily.POSTGRES),
    ORACLE_10g("oracle", 10, DatabaseFamily.ORACLE),
    ORACLE("oracle", DatabaseFamily.ORACLE),
    MS_SQL2005("mssql", 9, DatabaseFamily.MSSQL),
    MS_SQL("mssql", DatabaseFamily.MSSQL);

    private static final int MAJOR_VERSION_UNSPECIFIED = 0;
    private static final int MINOR_VERSION_UNSPECIFIED = -1;
    private String identifier;
    private int majorVersion;
    private int minorVersion;
    private DatabaseFamily family;

    private DatabaseType(String identifier, int majorVersion, DatabaseFamily family) {
        this(identifier, majorVersion, -1, family);
    }

    private DatabaseType(String identifier, int majorVersion, int minorVersion, DatabaseFamily family) {
        this.identifier = identifier;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.family = family;
    }

    private DatabaseType(String identifier, DatabaseFamily family) {
        this(identifier, 0, family);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public DatabaseFamily getFamily() {
        return this.family;
    }

    public boolean isFamilyOf(DatabaseFamily family) {
        return this.family.equals((Object)family);
    }

    public boolean matchesIdentifierAndMajorVersionAndMinorVersion(String databaseTypeName, int majorVersion, int minorVersion) {
        return !(!databaseTypeName.startsWith(this.identifier) || this.majorVersion != 0 && this.majorVersion != majorVersion || this.minorVersion != -1 && this.minorVersion != minorVersion);
    }
}

