/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util;

import com.atlassian.jira.util.BuildUtilsInfo;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionKit {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.?(\\d+)?");

    public static SoftwareVersion parse(String dottedVersionString) {
        return new SoftwareVersion(dottedVersionString);
    }

    public static SoftwareVersion version(int majorVersion, int ... versions) {
        int minorVersion = VersionKit.readArray(versions, 0, 0);
        int bugFixVersion = VersionKit.readArray(versions, 1, 0);
        return new SoftwareVersion(majorVersion, minorVersion, bugFixVersion);
    }

    public static SoftwareVersion version(BuildUtilsInfo buildUtilsInfo) {
        int[] versionNumbers = buildUtilsInfo.getVersionNumbers();
        return VersionKit.version(versionNumbers[0], Arrays.copyOfRange(versionNumbers, 1, versionNumbers.length));
    }

    private static int readArray(int[] versions, int index, int defaultVal) {
        if (index >= versions.length) {
            return defaultVal;
        }
        return versions[index];
    }

    public static class SoftwareVersion {
        private final int majorVersion;
        private final int minorVersion;
        private final int bugFixVersion;
        private final String dottedVersionString;

        public SoftwareVersion(String dottedVersionString) {
            this.dottedVersionString = dottedVersionString;
            Matcher versionMatcher = VERSION_PATTERN.matcher(dottedVersionString);
            if (!versionMatcher.find()) {
                throw new IllegalArgumentException("The dotted version string is not in the expected format");
            }
            this.majorVersion = this.decode(versionMatcher, 1, 0);
            this.minorVersion = this.decode(versionMatcher, 2, 0);
            this.bugFixVersion = this.decode(versionMatcher, 3, 0);
        }

        public SoftwareVersion(int majorVersion, int minorVersion, int bugfixVersion) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.bugFixVersion = bugfixVersion;
            this.dottedVersionString = String.format("%d.%d.%d", majorVersion, minorVersion, bugfixVersion);
        }

        public SoftwareVersion(int majorVersion, int minorVersion) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.bugFixVersion = 0;
            this.dottedVersionString = String.format("%d.%d", majorVersion, minorVersion);
        }

        private int decode(Matcher versionMatcher, int i, int defaultVal) {
            if (versionMatcher.group(i) != null) {
                return Integer.decode(versionMatcher.group(i));
            }
            return defaultVal;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public int getBugFixVersion() {
            return this.bugFixVersion;
        }

        public boolean isGreaterThanOrEqualTo(SoftwareVersion that) {
            if (this.equals(that)) {
                return true;
            }
            if (this.majorVersion < that.majorVersion) {
                return false;
            }
            if (this.majorVersion == that.majorVersion) {
                if (this.minorVersion < that.minorVersion) {
                    return false;
                }
                if (this.minorVersion == that.minorVersion && this.bugFixVersion < that.bugFixVersion) {
                    return false;
                }
            }
            return true;
        }

        public boolean isLessThanOrEqualTo(SoftwareVersion that) {
            if (this.equals(that)) {
                return true;
            }
            if (this.majorVersion > that.majorVersion) {
                return false;
            }
            if (this.majorVersion == that.majorVersion) {
                if (this.minorVersion > that.minorVersion) {
                    return false;
                }
                if (this.minorVersion == that.minorVersion && this.bugFixVersion > that.bugFixVersion) {
                    return false;
                }
            }
            return true;
        }

        public boolean isGreaterThan(SoftwareVersion that) {
            if (this.majorVersion > that.majorVersion) {
                return true;
            }
            if (this.majorVersion == that.majorVersion) {
                if (this.minorVersion > that.minorVersion) {
                    return true;
                }
                if (this.minorVersion == that.minorVersion && this.bugFixVersion > that.bugFixVersion) {
                    return true;
                }
            }
            return false;
        }

        public boolean isLessThan(SoftwareVersion that) {
            if (this.majorVersion < that.majorVersion) {
                return true;
            }
            if (this.majorVersion == that.majorVersion) {
                if (this.minorVersion < that.minorVersion) {
                    return true;
                }
                if (this.minorVersion == that.minorVersion && this.bugFixVersion < that.bugFixVersion) {
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SoftwareVersion that = (SoftwareVersion)o;
            if (this.bugFixVersion != that.bugFixVersion) {
                return false;
            }
            if (this.majorVersion != that.majorVersion) {
                return false;
            }
            return this.minorVersion == that.minorVersion;
        }

        public int hashCode() {
            int result = this.majorVersion;
            result = 31 * result + this.minorVersion;
            result = 31 * result + this.bugFixVersion;
            return result;
        }

        public String toString() {
            return this.dottedVersionString;
        }
    }
}

