/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class Transformer<P, R>
implements Function<P, R> {
    public R apply(@Nullable P p) {
        R r = this.make();
        this.transform(p, r);
        return r;
    }

    protected abstract R make();

    protected abstract void transform(P var1, R var2);

    public List<R> apply(List<P> elements) {
        ArrayList result = Lists.newArrayList();
        for (P p : elements) {
            result.add(this.apply(p));
        }
        return result;
    }

    public Set<R> apply(Set<P> elements) {
        HashSet result = Sets.newHashSet();
        for (P p : elements) {
            result.add(this.apply(p));
        }
        return result;
    }
}

