/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util;

import com.atlassian.greenhopper.model.I18n2;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.springframework.stereotype.Service;

@Service
public class TimeRemainingFormatter {
    private static final DurationFieldType[] DURATION_FIELD_TYPES = new DurationFieldType[]{DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes()};

    public TimeRemaining format(DateTime dateTime, I18n2 i18n) {
        ReadablePeriod difference;
        DateTime now = new DateTime();
        boolean inFuture = now.compareTo((ReadableInstant)dateTime) <= 0;
        ReadablePeriod readablePeriod = difference = inFuture ? this.computeDifference(now, dateTime) : this.computeDifference(dateTime, now);
        if (difference != null) {
            String suffixKey = inFuture ? "gh.time.left" : "gh.time.overdue";
            for (DurationFieldType type : DURATION_FIELD_TYPES) {
                if (!difference.isSupported(type)) continue;
                String text = i18n.getText("gh.time." + type.getName(), (Object)difference.get(type), (Object)i18n.getText(suffixKey));
                return new TimeRemaining(text, inFuture);
            }
        }
        return null;
    }

    private ReadablePeriod computeDifference(DateTime earlier, DateTime later) {
        Days days = Days.daysBetween((ReadableInstant)earlier, (ReadableInstant)later);
        if (days.getDays() >= 14) {
            return Weeks.weeksBetween((ReadableInstant)earlier, (ReadableInstant)later);
        }
        if (days.getDays() > 0) {
            return days;
        }
        Hours hours = Hours.hoursBetween((ReadableInstant)earlier, (ReadableInstant)later);
        if (hours.getHours() > 0) {
            return hours;
        }
        Minutes minutes = Minutes.minutesBetween((ReadableInstant)earlier, (ReadableInstant)later);
        if (minutes.getMinutes() >= 0) {
            return minutes;
        }
        return null;
    }

    public static class TimeRemaining {
        private final String text;
        private final boolean isFuture;

        public TimeRemaining(String text, boolean future) {
            this.text = text;
            this.isFuture = future;
        }

        public String getText() {
            return this.text;
        }

        public boolean isFuture() {
            return this.isFuture;
        }
    }
}

