/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util;

import com.atlassian.greenhopper.jira.actions.DetailsViewAjaxIssueAction;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.web.rapid.view.detailview.DetailViewInlineEditableFieldFactory;
import com.atlassian.jira.components.issueeditor.action.BaseEditAction;
import com.atlassian.jira.components.issueeditor.action.ContentIdCollector;
import com.atlassian.jira.components.issueviewer.viewissue.IssueFieldProvider;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webwork.action.Action;

@Service
public class DetailsViewIssueFieldProvider
extends IssueFieldProvider {
    @Autowired
    private DetailViewInlineEditableFieldFactory factory;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private RapidViewManager rapidViewService;

    public DetailsViewIssueFieldProvider() {
        super(null);
    }

    public List<FieldHtmlBean> getEditFields(ApplicationUser user, OperationContext operationContext, Action action, Issue issue, boolean retainValues, ContentIdCollector contentIdCollector) {
        if (!operationContext.getFieldValuesHolder().containsKey("REQUESTED_RAPID_VIEW_ID")) {
            throw new IllegalArgumentException("rapidViewId must be given in FieldValuesHolder");
        }
        Long rapidViewId = (Long)operationContext.getFieldValuesHolder().get("REQUESTED_RAPID_VIEW_ID");
        RapidView rapidView = this.rapidViewService.get(rapidViewId).getValue();
        if (rapidView == null) {
            throw new IllegalArgumentException("Requested Rapid View not found");
        }
        StatisticsField estimateStatisticField = this.estimateStatisticService.getEstimateStatistic(rapidView);
        StatisticsField remainingStatisticField = this.trackingStatisticService.getTrackingStatistic(rapidView);
        return this.factory.getInlineEditableFields(rapidViewId, issue.getId(), user, estimateStatisticField, remainingStatisticField, (BaseEditAction)((DetailsViewAjaxIssueAction)action)).getValue();
    }
}

