/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateMidnight;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public class DayIterator
implements Iterator<DateMidnight> {
    private final DateMidnight end;
    private DateMidnight current;
    private int dayNumber = 0;

    public DayIterator(DateMidnight start, DateMidnight end) {
        Validate.notNull((Object)start, (String)"Start date must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)end, (String)"End date must not be null", (Object[])new Object[0]);
        this.end = end;
        this.current = start;
    }

    @Override
    public boolean hasNext() {
        return !this.current.isAfter((ReadableInstant)this.end);
    }

    @Override
    public DateMidnight next() {
        DateMidnight next = this.current;
        if (next.isAfter((ReadableInstant)this.end)) {
            throw new NoSuchElementException();
        }
        this.current = this.current.plusDays(1);
        ++this.dayNumber;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getDayNumber() {
        return this.dayNumber;
    }

    public int getDaysLeft() {
        int days = Days.daysBetween((ReadableInstant)this.current, (ReadableInstant)this.end).getDays();
        return days < 0 ? 0 : days + 1;
    }
}

