/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util;

import java.util.Date;
import javax.annotation.Nullable;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class DateUtils {
    public static DateMidnight toDateMidnight(Date date, DateTimeZone timeZone) {
        return date != null ? new DateTime((Object)date, timeZone).toDateMidnight() : null;
    }

    public static DateMidnight toDateMidnight(Long date, DateTimeZone timeZone) {
        return date != null ? new DateTime((Object)date, timeZone).toDateMidnight() : null;
    }

    @Nullable
    public static DateMidnight toDateMidnight(Date date) {
        return date != null ? new DateTime((Object)date).toDateMidnight() : null;
    }

    public static DateMidnight toDateMidnight(@Nullable Date date, DateMidnight defaultDate) {
        DateMidnight dateMidnight = DateUtils.toDateMidnight(date);
        return dateMidnight != null ? dateMidnight : defaultDate;
    }

    public static boolean isInRange(ReadableInstant date, ReadableInstant startDate, ReadableInstant endDate) {
        return !(startDate != null && date.isBefore(startDate) || endDate != null && date.isAfter(endDate));
    }

    public static boolean isToday(DateMidnight date) {
        return new DateMidnight().equals((Object)date);
    }

    public static DateTime toDateTime(Date date) {
        return date != null ? new DateTime((Object)date) : null;
    }

    public static DateTime toDateTime(Date date, DateTimeZone timeZone) {
        return date != null && timeZone != null ? new DateTime((Object)date).withZoneRetainFields(timeZone) : null;
    }

    public static DateTime getTodayAt(DateTimeZone timeZone) {
        DateTime today = new DateTime();
        return timeZone != null ? today.withZoneRetainFields(timeZone) : today;
    }

    public static long truncateMilliseconds(long milliseconds) {
        return milliseconds / 1000L * 1000L;
    }

    public static long truncateMilliseconds(Date date) {
        return DateUtils.truncateMilliseconds(date.getTime());
    }
}

