/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.util;

import java.awt.Color;

public class ColorUtils {
    public static String colorToHex(Color color) {
        String rString = Integer.toHexString(color.getRed());
        String gString = Integer.toHexString(color.getGreen());
        String bString = Integer.toHexString(color.getBlue());
        return '#' + (rString.length() < 2 ? "0" : "") + rString + (gString.length() < 2 ? "0" : "") + gString + (bString.length() < 2 ? "0" : "") + bString;
    }

    public static Color hexToColor(String hex) {
        return ColorUtils.hexToColor(hex, null);
    }

    public static Color hexToColor(String hex, Color fallback) {
        if (hex == null) {
            return fallback;
        }
        try {
            return Color.decode(hex);
        }
        catch (NumberFormatException nfe) {
            return fallback;
        }
    }
}

