/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.user;

import com.atlassian.greenhopper.bridge.BridgeDetectionService;
import com.atlassian.greenhopper.user.UserIssueTypeManagerBridge;
import com.atlassian.greenhopper.user.UserIssueTypeManagerBridgeImpl;
import com.atlassian.greenhopper.web.CurrentRequestGetter;
import com.atlassian.jira.user.ApplicationUser;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserIssueTypeManagerBridgeFactory
implements FactoryBean {
    @Autowired
    private CurrentRequestGetter currentRequestGetter;
    @Autowired
    private BridgeDetectionService bridgeDetectionService;

    public Object getObject() throws Exception {
        return this.isUserIssueTypeEventManagerAvailable() ? new UserIssueTypeManagerBridgeImpl() : new UserIssueTypeManagerSessionBridge(this.currentRequestGetter);
    }

    public Class getObjectType() {
        return UserIssueTypeManagerBridge.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private boolean isUserIssueTypeEventManagerAvailable() {
        return this.bridgeDetectionService.isClassAvailable("com.atlassian.jira.user.UserIssueTypeManager");
    }

    private static class UserIssueTypeManagerSessionBridge
    implements UserIssueTypeManagerBridge {
        private final CurrentRequestGetter currentRequestGetter;

        public UserIssueTypeManagerSessionBridge(CurrentRequestGetter currentRequestGetter) {
            this.currentRequestGetter = currentRequestGetter;
        }

        @Override
        public void setLastUsedIssueTypeId(ApplicationUser user, String issueType) {
            this.currentRequestGetter.getCurrentSession().setAttribute("jira.user.history.issuetype", (Object)issueType);
        }

        @Override
        public String getLastUsedIssueTypeId(ApplicationUser user) {
            return (String)this.currentRequestGetter.getCurrentSession().getAttribute("jira.user.history.issuetype");
        }
    }
}

