/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.upgrade;

import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.service.PersistenceService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.greenhopper.util.BuildProperties;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpgradeVersionService {
    public static final Long LATEST_VERSION = 51L;
    private static final String GREEN_HOPPER_UPGRADE_HISTORY = "GreenHopper.UpgradeHistory";
    private static final String GREEN_HOPPER_RUN_HISTORY = "GreenHopper.Run.History";
    private static final String DD_MMM_YYYY_HH_MM = "dd MMM yyyy hh:mm";
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    private PersistenceService persistenceService;
    @Autowired
    private BuildProperties buildProperties;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private PluginSettingsFactory pluginSettingsFactory;
    private CachedReference<Option<Long>> latestUpgradedVersion;
    private transient PluginRunInfo currentRunInfo = null;

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).replicateViaInvalidation().build();
        this.latestUpgradedVersion = this.cacheFactoryManager.create().getCachedReference(UpgradeVersionService.class, UpgradeVersionService.class.getName() + ".latestUpgradedVersion", new LatestUpgradeSupplier(), cacheSettings);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onDataImportStarted(ImportStartedEvent event) {
        this.latestUpgradedVersion.reset();
    }

    public void setLatestUpgradedVersion(long upgradeTaskBuildNumber) {
        this.propertyDao.setLongProperty("GreenHopper.Upgrade.Latest.Upgraded.Version", upgradeTaskBuildNumber);
        this.latestUpgradedVersion.reset();
    }

    public boolean hasLastUpgradeTaskCompleted() {
        return LATEST_VERSION.equals(this.getLatestUpgradeTaskRun());
    }

    @Nullable
    public Long getLatestUpgradeTaskRun() {
        return (Long)this.latestUpgradedVersion.get().orElse(this::getBuildNumberFromSal).getOrNull();
    }

    private Option<Long> getBuildNumberFromSal() {
        Object buildNumberFromSal = this.pluginSettingsFactory.createGlobalSettings().get("com.pyxis.greenhopper.jira:build");
        try {
            return Option.option((Object)Long.parseLong(buildNumberFromSal.toString()));
        }
        catch (NullPointerException | NumberFormatException e) {
            return Option.none();
        }
    }

    public boolean hasAnyUpgradeTaskRunBefore() {
        return this.getLatestUpgradeTaskRun() != null;
    }

    @VisibleForTesting
    long getMinimumDataVersionRequiredForUpgrade() {
        return 45L;
    }

    public boolean versionLooksKosher() {
        if (!this.getCurrentPluginRunInfo().isDowngrade() && this.hasLastUpgradeTaskCompleted()) {
            return true;
        }
        this.currentRunInfo = null;
        return !this.getCurrentPluginRunInfo().isDowngrade() && this.hasLastUpgradeTaskCompleted();
    }

    public PluginRunInfo recordPluginStarted() {
        Pair<PluginRunInfo, Boolean> pair = this.getPluginRunInfoImpl();
        PluginRunInfo current = (PluginRunInfo)pair.first();
        this.persistenceService.setData(GREEN_HOPPER_RUN_HISTORY, 1L, "lastRunVersion", current.toPersistenceMap());
        if (((Boolean)pair.second()).booleanValue() || current.isDifferentPlugin()) {
            this.persistenceService.setData(GREEN_HOPPER_RUN_HISTORY, 2L, UpgradeVersionService.toIsoDateStr(new DateTime()), current.toPersistenceMap());
        }
        return current;
    }

    public PluginRunInfo getCurrentPluginRunInfo() {
        PluginRunInfo result = this.currentRunInfo;
        if (result == null) {
            Pair<PluginRunInfo, Boolean> pair = this.getPluginRunInfoImpl();
            this.currentRunInfo = result = (PluginRunInfo)pair.first();
        }
        return result;
    }

    private Pair<PluginRunInfo, Boolean> getPluginRunInfoImpl() {
        Long latestUpgradeTaskRun = this.defaultLong(this.getLatestUpgradeTaskRun(), 0L);
        Map<String, Object> prevData = this.persistenceService.getData(GREEN_HOPPER_RUN_HISTORY, 1L, "lastRunVersion");
        PluginRunInfo previousRunInfo = prevData == null ? new PluginRunInfo(new DateTime(), latestUpgradeTaskRun, this.buildProperties) : new PluginRunInfo(prevData, this.buildProperties);
        PluginRunInfo pluginRunInfo = new PluginRunInfo(previousRunInfo.getPreviousRanOn(), previousRunInfo.getLatestUpgradeTaskRun(), previousRunInfo.getCurrentVersion(), previousRunInfo.getCurrentBuildDate(), previousRunInfo.getPreviousChangeSet(), this.buildProperties);
        return Pair.of((Object)pluginRunInfo, (Object)(prevData == null ? 1 : 0));
    }

    public List<PluginRunInfo> getPluginRunHistory() {
        ArrayList runInfoList = Lists.newArrayList();
        Set<String> keys = this.defaultSet(this.persistenceService.getKeys(GREEN_HOPPER_RUN_HISTORY, 2L));
        for (String key : keys) {
            Map<String, Object> data = this.persistenceService.getData(GREEN_HOPPER_RUN_HISTORY, 2L, key);
            if (data == null) continue;
            runInfoList.add(new PluginRunInfo(data, this.buildProperties));
        }
        Collections.sort(runInfoList);
        return runInfoList;
    }

    public void recordUpgradeTaskStarted(int buildNumber) {
        this.recordUpgradeTaskRan(buildNumber, -1L, 1L);
    }

    public void recordUpgradeTaskEnded(int buildNumber, long timeTaken) {
        this.recordUpgradeTaskRan(buildNumber, timeTaken, 2L);
    }

    private void recordUpgradeTaskRan(int buildNumber, long timeTaken, Long entityId) {
        HashMap data = Maps.newHashMap();
        data.put("ranOn", UpgradeVersionService.toIsoDateStr(new DateTime()));
        data.put("buildNumber", String.valueOf(buildNumber));
        data.put("pluginVersion", this.buildProperties.getVersion());
        data.put("changeSet", this.buildProperties.getChangeSet());
        data.put("timeTaken", String.valueOf(timeTaken));
        this.persistenceService.setData(GREEN_HOPPER_UPGRADE_HISTORY, entityId, String.valueOf(new DateTime()), data);
    }

    public List<UpgradeHistoryDetail> getUpgradeHistory() {
        Map<String, Object> data;
        Set<String> startedKeys = this.defaultSet(this.persistenceService.getKeys(GREEN_HOPPER_UPGRADE_HISTORY, 1L));
        Set<String> endedKeys = this.defaultSet(this.persistenceService.getKeys(GREEN_HOPPER_UPGRADE_HISTORY, 2L));
        ArrayList upgradeHistoryDetails = Lists.newArrayList();
        for (String key : startedKeys) {
            data = this.persistenceService.getData(GREEN_HOPPER_UPGRADE_HISTORY, 1L, key);
            if (data == null) continue;
            upgradeHistoryDetails.add(new UpgradeHistoryDetail(data));
        }
        for (String key : endedKeys) {
            data = this.persistenceService.getData(GREEN_HOPPER_UPGRADE_HISTORY, 2L, key);
            if (data == null) continue;
            upgradeHistoryDetails.add(new UpgradeHistoryDetail(data));
        }
        Collections.sort(upgradeHistoryDetails);
        return upgradeHistoryDetails;
    }

    private Set<String> defaultSet(Set<String> keys) {
        return keys == null ? Sets.newHashSet() : keys;
    }

    private Long defaultLong(Long l1, Long defaultLong) {
        return l1 == null ? defaultLong : l1;
    }

    private static String toIsoDateStr(DateTime dateTime) {
        return dateTime.toString(ISODateTimeFormat.dateTime());
    }

    private static DateTime parseIsoDate(String isoDTStr) {
        return ISODateTimeFormat.dateTime().parseDateTime(isoDTStr);
    }

    private class LatestUpgradeSupplier
    implements Supplier<Option<Long>> {
        private LatestUpgradeSupplier() {
        }

        @Override
        public Option<Long> get() {
            Long value = UpgradeVersionService.this.propertyDao.getLongProperty("GreenHopper.Upgrade.Latest.Upgraded.Version");
            return Option.option((Object)value);
        }
    }

    public static class UpgradeHistoryDetail
    implements Comparable<UpgradeHistoryDetail> {
        private final DateTime ranOn;
        private final String buildNumber;
        private final String pluginVersion;
        private final String changeSet;
        private final String timeTaken;
        private final boolean startRecord;

        public UpgradeHistoryDetail(Map<String, Object> data) {
            this.ranOn = UpgradeVersionService.parseIsoDate(String.valueOf(data.get("ranOn")));
            this.buildNumber = String.valueOf(data.get("buildNumber"));
            this.pluginVersion = String.valueOf(data.get("pluginVersion"));
            this.changeSet = String.valueOf(data.get("changeSet"));
            String timeTakenStr = String.valueOf(data.get("timeTaken"));
            if ("-1".equals(timeTakenStr)) {
                this.timeTaken = "";
                this.startRecord = true;
            } else {
                this.timeTaken = timeTakenStr;
                this.startRecord = false;
            }
        }

        public DateTime getRanOn() {
            return this.ranOn;
        }

        public String getRanOnStr() {
            return this.ranOn.toString(DateTimeFormat.forPattern((String)UpgradeVersionService.DD_MMM_YYYY_HH_MM));
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public String getChangeSet() {
            return this.changeSet;
        }

        public String getTimeTaken() {
            return this.timeTaken;
        }

        public boolean isStartRecord() {
            return this.startRecord;
        }

        @Override
        public int compareTo(UpgradeHistoryDetail that) {
            return this.ranOn.compareTo((ReadableInstant)that.ranOn);
        }
    }

    public static class PluginRunInfo
    implements Comparable<PluginRunInfo> {
        private final String currentVersion;
        private final DateTime currentBuildDate;
        private final String previousVersion;
        private final DateTime previousBuildDate;
        private final String currentChangeSet;
        private final String previousChangeSet;
        private final Long latestUpgradeTaskRun;
        private final DateTime previousRanOn;
        private final DateTime currentRanOn;
        private final boolean downgrade;

        public PluginRunInfo(DateTime previousRanOn, Long latestUpgradeTaskRun, BuildProperties buildProperties) {
            this(previousRanOn, latestUpgradeTaskRun, buildProperties.getVersion(), buildProperties.getBuildDate(), buildProperties.getChangeSet(), buildProperties);
        }

        public PluginRunInfo(Map<String, Object> data, BuildProperties buildProperties) {
            this(UpgradeVersionService.parseIsoDate(String.valueOf(data.get("ranOn"))), Long.valueOf(String.valueOf(data.get("latestUpgradeTaskRun"))), String.valueOf(data.get("pluginVersion")), UpgradeVersionService.parseIsoDate(String.valueOf(data.get("buildDate"))), String.valueOf(data.get("changeSet")), buildProperties);
        }

        public PluginRunInfo(DateTime previousRanOn, Long latestUpgradeTaskRun, String previousVersion, DateTime previousBuildDate, String previousChangeSet, BuildProperties buildProperties) {
            this.previousRanOn = previousRanOn;
            this.previousVersion = previousVersion;
            this.previousBuildDate = previousBuildDate;
            this.previousChangeSet = previousChangeSet;
            this.currentVersion = buildProperties.getVersion();
            this.currentBuildDate = buildProperties.getBuildDate();
            this.currentChangeSet = buildProperties.getChangeSet();
            this.currentRanOn = new DateTime();
            this.latestUpgradeTaskRun = latestUpgradeTaskRun;
            this.downgrade = this.currentBuildDate.isBefore((ReadableInstant)previousBuildDate);
        }

        public Map<String, Object> toPersistenceMap() {
            HashMap map = Maps.newHashMap();
            map.put("pluginVersion", this.currentVersion);
            map.put("buildDate", UpgradeVersionService.toIsoDateStr(this.currentBuildDate));
            map.put("changeSet", this.currentChangeSet);
            map.put("latestUpgradeTaskRun", String.valueOf(this.latestUpgradeTaskRun));
            map.put("ranOn", UpgradeVersionService.toIsoDateStr(this.currentRanOn));
            return map;
        }

        @Override
        public int compareTo(PluginRunInfo that) {
            return this.previousRanOn.compareTo((ReadableInstant)that.previousRanOn);
        }

        public String getCurrentVersion() {
            return this.currentVersion;
        }

        public DateTime getCurrentBuildDate() {
            return this.currentBuildDate;
        }

        public String getCurrentChangeSet() {
            return this.currentChangeSet;
        }

        public DateTime getCurrentRanOn() {
            return this.currentRanOn;
        }

        public Long getLatestUpgradeTaskRun() {
            return this.latestUpgradeTaskRun;
        }

        public String getPreviousVersion() {
            return this.previousVersion;
        }

        public DateTime getPreviousBuildDate() {
            return this.previousBuildDate;
        }

        public String getPreviousChangeSet() {
            return this.previousChangeSet;
        }

        public DateTime getPreviousRanOn() {
            return this.previousRanOn;
        }

        public String getRanOnStr() {
            return this.previousRanOn.toString(DateTimeFormat.forPattern((String)UpgradeVersionService.DD_MMM_YYYY_HH_MM));
        }

        public boolean isDowngrade() {
            return this.downgrade;
        }

        public boolean isDifferentPlugin() {
            return !this.previousChangeSet.equals(this.currentChangeSet);
        }
    }
}

